/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyInTankTickAction;

public class EmptyFluidContainerInTankTickAction<T extends TickingTankInventoryTileEntity<T>>
extends EmptyInTankTickAction<T> {
    @Override
    public void onTick(T tile, ItemStack itemStack, int slot, int tick) {
        ItemStack containerStack = tile.getInventory().func_70301_a(slot);
        IFluidContainerItem container = (IFluidContainerItem)containerStack.func_77973_b();
        if (container.getFluid(containerStack) != null) {
            FluidStack fluidStack = container.getFluid(containerStack);
            fluidStack.amount = Math.min(MB_PER_TICK, fluidStack.amount);
            int filled = tile.getTank().fill(fluidStack, true);
            container.drain(containerStack, filled, true);
        }
    }

    @Override
    public float getRequiredTicks(T tile, int slot, int tick) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, tile.getInventory().func_70301_a(slot));
    }

    public static int getRequiredTicks(TankInventoryTileEntity tile, ItemStack itemStack) {
        IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
        int amount = 0;
        if (container.getFluid(itemStack) != null) {
            amount = container.getFluid((ItemStack)itemStack).amount;
        }
        int capacity = Math.min(container.getCapacity(itemStack), tile.getTank().getFluidAmount());
        return (capacity - amount) / MB_PER_TICK;
    }

    @Override
    public boolean canTick(T tile, ItemStack itemStack, int slot, int tick) {
        boolean emptyContainer = false;
        ItemStack containerStack = tile.getInventory().func_70301_a(slot);
        IFluidContainerItem container = (IFluidContainerItem)containerStack.func_77973_b();
        if (container.getFluid(containerStack) != null) {
            FluidStack fluidStack = container.getFluid(containerStack);
            if (fluidStack.amount <= 0) {
                emptyContainer = true;
            }
        } else {
            emptyContainer = true;
        }
        return super.canTick(tile, itemStack, slot, tick) && !emptyContainer;
    }
}

