/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.world.gen.structure.QuarterSymmetricalStructure;

public class DarkTempleStructure
extends QuarterSymmetricalStructure {
    private static final int STRUCTURE_HEIGHT = 9;
    private static final int[] CORNER_INC = new int[]{-1, 1};
    private static DarkTempleStructure _instance = null;

    public static DarkTempleStructure getInstance() {
        if (_instance == null) {
            _instance = new DarkTempleStructure();
        }
        return _instance;
    }

    private DarkTempleStructure() {
        super(6, 6);
    }

    private int findGround(World world, int x, int z, int yMin, int yMax) {
        if (yMin <= yMax) {
            for (int height = yMax; height >= yMin; --height) {
                while (height >= yMin && (world.func_175623_d(new BlockPos(x, height, z)) || !world.func_175623_d(new BlockPos(x, height + 1, z)))) {
                    --height;
                }
                if (height < yMin || !this.isValidSpot(world, new BlockPos(x, height, z))) continue;
                return height;
            }
        }
        return -1;
    }

    private boolean canPlaceStructure(World world, BlockPos blockPos) {
        return (Boolean)WorldHelpers.foldArea((World)world, (int[])new int[]{3, 0, 3}, (int[])new int[]{3, 9, 3}, (BlockPos)blockPos, (WorldHelpers.WorldFoldingFunction)new WorldHelpers.WorldFoldingFunction<Boolean, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable Boolean from, World world, BlockPos blockPos) {
                return from != false && !DarkTempleStructure.this.isSolidBlock(world, blockPos);
            }
        }, (Object)true);
    }

    private boolean isValidSpot(World world, BlockPos blockPos) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        return this.isSolidBlock(block) || block.func_176200_f(world, blockPos);
    }

    private boolean isSolidBlock(World world, BlockPos blockPos) {
        return this.isSolidBlock(world.func_180495_p(blockPos).func_177230_c());
    }

    private boolean isSolidBlock(Block block) {
        Material material = block.func_149688_o();
        return material.func_76220_a() && material.func_76218_k();
    }

    private int getMaxPillarHeightAt(World world, BlockPos blockPos) {
        int max = 0;
        int[] arr$ = CORNER_INC;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer incX = arr$[i$];
            int[] arr$2 = CORNER_INC;
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Integer incZ = arr$2[i$2];
                max = Math.max(max, this.getPillarHeightForCornerAt(world, blockPos, incX, incZ));
            }
        }
        return max;
    }

    private int getPillarHeightForCornerAt(World world, BlockPos blockPos, int incX, int incZ) {
        BlockPos loopPos = blockPos.func_177982_a(4 * incX, 0, 4 * incZ);
        int res = 0;
        while (!this.isSolidBlock(world, loopPos)) {
            loopPos = loopPos.func_177982_a(0, -1, 0);
            ++res;
        }
        return res;
    }

    @Override
    protected void generateLayers() {
        QuarterSymmetricalStructure.BlockWrapper us = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
        QuarterSymmetricalStructure.BlockWrapper rs = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper((Block)Blocks.field_150333_U);
        QuarterSymmetricalStructure.BlockWrapper ds = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper((Block)Blocks.field_150334_T);
        QuarterSymmetricalStructure.BlockWrapper cb = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        QuarterSymmetricalStructure.BlockWrapper sb = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150417_aV);
        QuarterSymmetricalStructure.BlockWrapper cs = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        QuarterSymmetricalStructure.BlockWrapper co = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150347_e);
        QuarterSymmetricalStructure.BlockWrapper wa = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper((Block)Blocks.field_150355_j);
        QuarterSymmetricalStructure.BlockWrapper fe = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_180406_aS);
        QuarterSymmetricalStructure.BlockWrapper to = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150478_aa);
        QuarterSymmetricalStructure.BlockWrapper cw = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150463_bK);
        QuarterSymmetricalStructure.BlockWrapper lc = new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150486_ae.func_176223_P(), 0.15f);
        lc.action = new QuarterSymmetricalStructure.IBlockAction(){

            @Override
            public void run(World world, BlockPos pos) {
                Random rand = new Random();
                TileEntityChest tile = (TileEntityChest)world.func_175625_s(pos);
                if (tile != null) {
                    ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                    WeightedRandomChestContent.func_177630_a((Random)rand, (List)info.getItems(rand), (IInventory)tile, (int)info.getCount(rand));
                }
            }
        };
        QuarterSymmetricalStructure.BlockWrapper vi = new QuarterSymmetricalStructure.BlockWrapper(Blocks.field_150395_bd.func_176223_P(), 0.3f);
        vi.action = new QuarterSymmetricalStructure.IBlockAction(){

            @Override
            public void run(World world, BlockPos pos) {
                boolean atLeastOne = false;
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    if (!world.isSideSolid(pos.func_177972_a(side), side.func_176734_d(), true)) continue;
                    world.func_180501_a(pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176274_P[side.ordinal() - 1], (Comparable)Boolean.valueOf(true)), 2);
                    atLeastOne = true;
                }
                if (!atLeastOne) {
                    world.func_175698_g(pos);
                }
            }
        };
        QuarterSymmetricalStructure.BlockWrapper ea = (QuarterSymmetricalStructure)this.new QuarterSymmetricalStructure.BlockWrapper((Block)EnvironmentalAccumulator.getInstance());
        Object o = null;
        this.addLayer(1, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, us, ds, vi, us, us, us, us, us, o, us, us, us, us, o, o, us, us, us, us, o, o, us, us, us, us, o, o});
        this.addLayer(2, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, vi, vi, o, o, o, o, cb, cb, vi, sb, sb, sb, sb, cb, vi, ds, co, wa, sb, o, o, co, co, co, sb, o, o, co, co, ds, sb, o, o});
        this.addLayer(3, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, lc, sb, vi, o, o, o, fe, lc, o, rs, o, o, o, o, o, cs, rs, o, o, o, o, ea, cs, rs, o, o, o});
        this.addLayer(4, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, vi, cb, vi, o, o, o, to, vi, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o});
        this.addLayer(5, new QuarterSymmetricalStructure.BlockWrapper[]{us, o, o, o, cw, o, o, o, o, o, sb, cw, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, us});
        this.addLayer(6, new QuarterSymmetricalStructure.BlockWrapper[]{cb, ds, rs, rs, rs, o, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, ds, o, co, co, co, co, cb});
        this.addLayer(7, new QuarterSymmetricalStructure.BlockWrapper[]{rs, o, o, o, o, o, cw, o, o, o, o, o, cs, cs, cs, o, o, o, co, co, cs, cs, o, o, co, co, co, cs, o, o, o, co, co, cs, cw, rs});
        this.addLayer(8, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, cs, cw, o, o, o, o, o, cs, o, o, o, o});
        this.addLayer(9, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o});
    }

    @Override
    protected void postBuildCorner(World world, BlockPos blockPos, int incX, int incZ) {
        world.func_180501_a(blockPos.func_177982_a(3 * incX, 5, 4 * incZ), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)DirectionHelpers.getEnumFacingFromXSign((int)incX)).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT), 2);
        world.func_180501_a(blockPos.func_177982_a(4 * incX, 5, 3 * incZ), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)DirectionHelpers.getEnumFacingFromZSing((int)incZ)).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT), 2);
        int xx = 4 * incX;
        int zz = 4 * incZ;
        int pillarHeight = this.getPillarHeightForCornerAt(world, blockPos, incX, incZ);
        for (int yOffset = 0; yOffset < pillarHeight; ++yOffset) {
            world.func_180501_a(blockPos.func_177982_a(xx, -yOffset, zz), Blocks.field_150347_e.func_176223_P(), 2);
        }
    }

    @Override
    public boolean generate(World world, Random random, BlockPos blockPos) {
        int x = blockPos.func_177958_n();
        int z = blockPos.func_177952_p();
        int groundHeight = this.findGround(world, x, z, DarkTempleStructure.getMinBuildHeight(), DarkTempleStructure.getMaxBuildHeight());
        while (groundHeight != -1) {
            BlockPos location = new BlockPos(x, groundHeight, z);
            if (this.canPlaceStructure(world, location.func_177982_a(0, 1, 0))) {
                if (this.getMaxPillarHeightAt(world, blockPos) > GeneralConfig.darkTempleMaxPillarLength) {
                    return false;
                }
                super.generate(world, random, location);
                return true;
            }
            groundHeight = this.findGround(world, x, z, DarkTempleStructure.getMinBuildHeight(), groundHeight - 1);
        }
        return false;
    }

    private static int getMinBuildHeight() {
        return GeneralConfig.darkTempleMinHeight;
    }

    private static int getMaxBuildHeight() {
        return GeneralConfig.darkTempleMaxHeight - 9;
    }
}

