/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public abstract class QuarterSymmetricalStructure {
    private List<Integer> layerHeights = new ArrayList<Integer>();
    private List<BlockWrapper[]> layers = new ArrayList<BlockWrapper[]>();
    protected int quarterWidth;
    protected int quarterHeight;

    public QuarterSymmetricalStructure(int quarterWidth, int quarterHeight) {
        this.quarterWidth = quarterWidth;
        this.quarterHeight = quarterHeight;
        this.generateLayers();
    }

    protected abstract void generateLayers();

    protected void addLayer(int height, BlockWrapper[] layer) {
        this.layerHeights.add(height);
        this.layers.add(layer);
    }

    protected void buildCorner(World world, BlockPos blockPos, int incX, int incZ) {
        Random r = new Random();
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.quarterHeight; ++zr) {
                for (int xr = start; xr < this.quarterWidth; ++xr) {
                    BlockWrapper wrapper = layer[(this.quarterWidth - xr - 1) * this.quarterHeight + zr];
                    BlockPos posOffset = blockPos.func_177982_a(xr * incX, layerHeight, zr * incZ);
                    if (wrapper == null || !(wrapper.chance >= r.nextFloat())) continue;
                    world.func_180501_a(blockPos.func_177982_a(xr * incX, layerHeight, zr * incZ), wrapper.blockState, 2);
                    if (wrapper.action == null) continue;
                    wrapper.action.run(world, posOffset);
                }
            }
        }
        this.postBuildCorner(world, blockPos, incX, incZ);
    }

    protected void postBuildCorner(World world, BlockPos pos, int incX, int incZ) {
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.quarterHeight; ++zr) {
                for (int xr = start; xr < this.quarterWidth; ++xr) {
                    BlockWrapper wrapper = layer[(this.quarterWidth - xr - 1) * this.quarterHeight + zr];
                    if (wrapper == null) continue;
                    BlockPos posOffset = pos.func_177982_a(xr * incX, layerHeight, zr * incZ);
                    if (wrapper.action == null || world.func_180495_p(posOffset) != wrapper.blockState) continue;
                    wrapper.action.run(world, posOffset);
                }
            }
        }
    }

    public boolean generate(World world, Random random, BlockPos blockPos) {
        this.buildCorner(world, blockPos, 1, 1);
        this.buildCorner(world, blockPos, -1, 1);
        this.buildCorner(world, blockPos, 1, -1);
        this.buildCorner(world, blockPos, -1, -1);
        return true;
    }

    public static interface IBlockAction {
        public void run(World var1, BlockPos var2);
    }

    public class BlockWrapper {
        public IBlockState blockState;
        public float chance = 1.0f;
        public IBlockAction action = null;

        public BlockWrapper(Block block) {
            this(block.func_176223_P());
        }

        public BlockWrapper(IBlockState blockState) {
            this.blockState = blockState;
        }

        public BlockWrapper(IBlockState blockState, float chance) {
            this(blockState);
            this.chance = chance;
        }
    }
}

