/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.evilcraft.core.world.FakeWorld;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;
import org.cyclops.evilcraft.tileentity.TileBoxOfEternalClosure;

public class BoxOfEternalClosure
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockRarityProvider {
    public static final String FORGOTTEN_PLAYER = "Forgotten Player";
    private static final int LIGHT_LEVEL = 6;
    private static BoxOfEternalClosure _instance = null;

    public static BoxOfEternalClosure getInstance() {
        return _instance;
    }

    public BoxOfEternalClosure(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileBoxOfEternalClosure.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149780_i);
        this.setRotatable(true);
    }

    public void func_180654_a(IBlockAccess world, BlockPos blockPos) {
        CyclopsTileEntity tile = (CyclopsTileEntity)world.func_175625_s(blockPos);
        if (tile.getRotation() == EnumFacing.EAST || tile.getRotation() == EnumFacing.WEST) {
            this.func_149676_a(0.2f, 0.0f, 0.0f, 0.8f, 0.43f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.2f, 1.0f, 0.43f, 0.8f);
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public int getSpiritID(ItemStack itemStack) {
        String innerEntity;
        NBTTagCompound spiritTag;
        if (this.hasPlayer(itemStack)) {
            return -1;
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null && (spiritTag = tag.func_74775_l("spiritTag")) != null && (innerEntity = spiritTag.func_74779_i("innerEntity")) != null && !innerEntity.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(innerEntity);
                if (!VengeanceSpirit.canSustainClass(clazz)) {
                    return -1;
                }
                Integer ret = ObfuscationHelpers.getClassToID().get(clazz);
                if (ret == null) {
                    return -1;
                }
                return ret;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public String getSpiritName(ItemStack itemStack) {
        NBTTagCompound spiritTag;
        if (this.hasPlayer(itemStack)) {
            return "Zombie";
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null && (spiritTag = tag.func_74775_l("spiritTag")) != null && !spiritTag.func_82582_d()) {
            String innerEntity = spiritTag.func_74779_i("innerEntity");
            if (innerEntity != null && !innerEntity.isEmpty()) {
                try {
                    Class<?> clazz = Class.forName(innerEntity);
                    if (!VengeanceSpirit.canSustainClass(clazz)) {
                        return null;
                    }
                    return (String)EntityList.field_75626_c.get(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                return "vengeanceSpirit";
            }
        }
        return null;
    }

    public static void setVengeanceSwarmContent(ItemStack itemStack) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound spiritTag = new NBTTagCompound();
        VengeanceSpirit spirit = new VengeanceSpirit(FakeWorld.getInstance());
        spirit.setGlobalVengeance(true);
        spirit.setIsSwarm(true);
        spirit.func_70109_d(spiritTag);
        String entityId = EntityList.func_75621_b((Entity)spirit);
        spiritTag.func_74778_a("id", entityId);
        tag.func_74782_a("spiritTag", (NBTBase)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public static void setPlayerContent(ItemStack itemStack, UUID playerId) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound spiritTag = new NBTTagCompound();
        VengeanceSpirit spirit = new VengeanceSpirit(FakeWorld.getInstance());
        spirit.setPlayerId(playerId.toString());
        spirit.setPlayerName(FORGOTTEN_PLAYER);
        tag.func_74778_a("playerId", spirit.getPlayerId());
        tag.func_74778_a("playerName", spirit.getPlayerName());
        spirit.setGlobalVengeance(true);
        spirit.func_70109_d(spiritTag);
        String entityId = EntityList.func_75621_b((Entity)spirit);
        spiritTag.func_74778_a("id", entityId);
        tag.func_74782_a("spiritTag", (NBTBase)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public String getPlayerName(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerName", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return itemStack.func_77978_p().func_74779_i("playerName");
        }
        return "";
    }

    public String getPlayerId(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerId", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return itemStack.func_77978_p().func_74779_i("playerId");
        }
        return "";
    }

    public boolean hasPlayer(ItemStack itemStack) {
        return !this.getPlayerId(itemStack).isEmpty();
    }

    public String getInfo(ItemStack itemStack) {
        String content = EnumChatFormatting.ITALIC + L10NHelpers.localize((String)"general.evilcraft.info.empty");
        if (this.hasPlayer(itemStack)) {
            content = this.getPlayerName(itemStack);
        } else {
            String id = this.getSpiritName(itemStack);
            if (id != null) {
                content = L10NHelpers.getLocalizedEntityName((String)id);
            }
        }
        return EnumChatFormatting.BOLD + L10NHelpers.localize((String)(this.func_149739_a() + ".info.content"), (Object[])new Object[]{EnumChatFormatting.RESET + content});
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    public boolean func_176196_c(World world, BlockPos blockPos) {
        return World.func_175683_a((IBlockAccess)world, (BlockPos)blockPos.func_177982_a(0, -1, 0));
    }

    public void func_176204_a(World world, BlockPos blockPos, IBlockState blockState, Block block) {
        if (!this.func_176196_c(world, blockPos)) {
            this.func_176226_b(world, blockPos, blockState, 0);
            world.func_175698_g(blockPos);
        }
        super.func_176204_a(world, blockPos, blockState, block);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).getSpiritInstance() != null) {
            world.func_72908_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, "random.chestopen", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (!world.field_72995_K) {
                tile.releaseSpirit();
            }
            return true;
        }
        return super.func_180639_a(world, blockPos, state, entityplayer, side, hitX, hitY, hitZ);
    }

    public int getLightValue(IBlockAccess world, BlockPos blockPos) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).getLidAngle() > 0.0f) {
            return 6;
        }
        return super.getLightValue(world, blockPos);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item));
        ItemStack swarmStack = new ItemStack(item);
        BoxOfEternalClosure.setVengeanceSwarmContent(swarmStack);
        list.add(swarmStack);
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack) {
        return this.hasPlayer(itemStack) ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos blockPos) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).getSpiritInstance() != null) {
            return 15;
        }
        return super.func_180641_l(world, blockPos);
    }
}

