/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.DarkTankConfig;
import org.cyclops.evilcraft.client.render.model.ModelDarkTank;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.block.component.BlockTankComponent;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.fluid.BloodConfig;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class DarkTank
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockTank {
    private static final String NBT_TAG_CAPACITY = "tankCapacity";
    @BlockProperty
    public static final PropertyBool DRAINING = PropertyBool.func_177716_a((String)"draining");
    private static DarkTank _instance = null;
    private BlockTankComponent<DarkTank> tankComponent = new BlockTankComponent<DarkTank>(this);
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation[] itemModels;

    public static DarkTank getInstance() {
        return _instance;
    }

    public DarkTank(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151592_s, TileDarkTank.class);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149778_k);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (MinecraftHelpers.isClientSide()) {
            this.itemModels = new ModelResourceLocation[2];
            this.itemModels[0] = new ModelResourceLocation(eConfig.getMod().getModId() + ":" + eConfig.getNamedId() + "_off", "inventory");
            this.itemModels[1] = new ModelResourceLocation(eConfig.getMod().getModId() + ":" + eConfig.getNamedId() + "_on", "inventory");
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.125f, 0.001f, 0.125f, 0.875f, 0.999f, 0.875f);
    }

    public void func_180654_a(IBlockAccess world, BlockPos blockPos) {
        this.func_149683_g();
    }

    public void func_180638_a(World world, BlockPos blockPos, IBlockState blockState, AxisAlignedBB area, List list, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, list, entity);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos blockPos) {
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_175625_s(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumFacing side, float motionX, float motionY, float motionZ) {
        if (this.tankComponent.onBlockActivatedTank(world, blockPos, player, side, motionX, motionY, motionZ)) {
            return true;
        }
        world.func_180501_a(blockPos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)DRAINING, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((IProperty)DRAINING) == false)), 2);
        return true;
    }

    public String getInfo(ItemStack itemStack) {
        return this.tankComponent.getInfoTank(itemStack);
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    @Override
    public String getTankNBTName() {
        return "darkTank";
    }

    @Override
    public int getTankCapacity(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null || !tag.func_74764_b(NBT_TAG_CAPACITY)) {
            return 16000;
        }
        return tag.func_74762_e(NBT_TAG_CAPACITY);
    }

    @Override
    public void setTankCapacity(ItemStack itemStack, int capacity) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        this.setTankCapacity(tag, capacity);
    }

    @Override
    public void setTankCapacity(NBTTagCompound tag, int capacity) {
        tag.func_74768_a(NBT_TAG_CAPACITY, capacity);
    }

    public void writeAdditionalInfo(TileEntity tile, NBTTagCompound tag) {
        super.writeAdditionalInfo(tile, tag);
        this.tankComponent.writeAdditionalInfo(tile, tag);
    }

    public int getLightValue(IBlockAccess world, BlockPos blockPos) {
        TileDarkTank tank;
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile != null && tile instanceof TileDarkTank && (tank = (TileDarkTank)tile).getTank().getFluidType() != null) {
            return (int)Math.min(15.0, tank.getFillRatio() * (double)tank.getTank().getFluidType().getLuminosity() * 15.0);
        }
        return 0;
    }

    @Override
    public int getMaxCapacity() {
        return DarkTankConfig.maxTankSize;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack activated = itemStack.func_77946_l();
                activated.func_77964_b(1 - activated.func_77952_i());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world, Entity entity) {
        return itemStack.func_77952_i() == 1;
    }

    public int func_180651_a(IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)DRAINING) != false ? 1 : 0;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack(item);
        int capacity = capacityOriginal = 16000;
        do {
            this.setTankCapacity(itemStack, capacity);
            list.add(itemStack.func_77946_l());
            if (Configs.isEnabled(BloodConfig.class)) {
                ItemStack itemStackFilled = itemStack.func_77946_l();
                IFluidContainerItem container = (IFluidContainerItem)itemStackFilled.func_77973_b();
                container.fill(itemStackFilled, new FluidStack((Fluid)Blood.getInstance(), capacity), true);
                list.add(itemStackFilled);
            }
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(DarkTankConfig.maxTankCreativeSize, DarkTankConfig.maxTankSize) && capacity > lastCapacity);
        if (DarkTankConfig.creativeTabFluids) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid == null || fluid == Blood.getInstance()) continue;
                try {
                    ItemStack itemStackFilled = itemStack.func_77946_l();
                    this.setTankCapacity(itemStackFilled, capacityOriginal);
                    IFluidContainerItem container = (IFluidContainerItem)itemStackFilled.func_77973_b();
                    container.fill(itemStackFilled, new FluidStack(fluid, capacityOriginal), true);
                    list.add(itemStackFilled);
                }
                catch (NullPointerException e) {}
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (ModelResourceLocation itemModel : this.itemModels) {
            IBakedModel baseModel = (IBakedModel)event.modelRegistry.func_82594_a((Object)itemModel);
            ModelDarkTank newModel = new ModelDarkTank(baseModel);
            event.modelRegistry.func_82595_a((Object)itemModel, (Object)newModel);
        }
    }
}

