/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.ExcrementPileConfig;
import org.cyclops.evilcraft.item.Broom;
import org.cyclops.evilcraft.item.BroomConfig;

public class ExcrementPile
extends ConfigurableBlock {
    @BlockProperty
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)1, (int)8);
    private static ExcrementPile _instance = null;
    private static final int CHANCE_DESPAWN = 1;
    private static final int CHANCE_BONEMEAL = 3;
    private static final int POISON_DURATION = 3;
    private static final int PIG_BOOST_DURATION = 3;

    public static ExcrementPile getInstance() {
        return _instance;
    }

    public ExcrementPile(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151571_B);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.func_149675_a(true);
        this.setBlockBoundsForPileDepth(0);
    }

    public Item func_180660_a(IBlockState blockState, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LAYERS) < 5;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)LAYERS) - 1;
        float f = 0.125f;
        return new AxisAlignedBB((double)pos.func_177958_n() + this.field_149759_B, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + this.field_149754_D, (double)pos.func_177958_n() + this.field_149755_E, (double)((float)pos.func_177956_o() + (float)i * f), (double)pos.func_177952_p() + this.field_149757_G);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public void func_149683_g() {
        this.setBlockBoundsForPileDepth(0);
    }

    public void func_180654_a(IBlockAccess world, BlockPos blockPos) {
        this.setBlockBoundsForPileDepth(world.func_180495_p(blockPos));
    }

    protected void setBlockBoundsForPileDepth(int height) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, (float)height / 8.0f, 1.0f);
    }

    protected int getHeight(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)LAYERS);
    }

    protected void setBlockBoundsForPileDepth(IBlockState blockState) {
        this.setBlockBoundsForPileDepth(this.getHeight(blockState));
    }

    public boolean func_176196_c(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos.func_177982_a(0, -1, 0));
        if (blockState == null) {
            return false;
        }
        if (blockState.func_177230_c() == this && (Integer)blockState.func_177229_b((IProperty)LAYERS) == 8) {
            return true;
        }
        return (blockState.func_177230_c().isLeaves((IBlockAccess)world, blockPos.func_177982_a(0, -1, 0)) || blockState.func_177230_c().func_149662_c()) && blockState.func_177230_c().func_149688_o().func_76230_c();
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos blockPos, EntityPlayer player) {
        return player.func_71045_bC() != null && Configs.isEnabled(BroomConfig.class) && player.func_71045_bC().func_77973_b() == Broom.getInstance();
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos blockPos, IBlockState blockState, TileEntity tile) {
        super.func_180657_a(world, player, blockPos, blockState, tile);
        world.func_175698_g(blockPos);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public void func_180650_b(World world, BlockPos blockPos, IBlockState blockState, Random random) {
        if (random.nextInt(1) == 0) {
            if (random.nextInt(3) == 0) {
                for (int xr = -2; xr <= 2; ++xr) {
                    for (int zr = -2; zr <= 2; ++zr) {
                        if (random.nextInt(9) != 0) continue;
                        IBlockState blockBelow = world.func_180495_p(blockPos.func_177982_a(xr, -1, zr));
                        if (blockBelow.func_177230_c() == Blocks.field_150346_d) {
                            world.func_175656_a(blockPos.func_177982_a(xr, -1, zr), Blocks.field_150349_c.func_176223_P());
                        } else if (blockBelow == Blocks.field_150349_c) {
                            ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1), (World)world, (BlockPos)blockPos.func_177982_a(xr, -1, zr));
                        }
                        ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1), (World)world, (BlockPos)blockPos.func_177982_a(xr, -1, zr));
                    }
                }
            }
            world.func_175698_g(blockPos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos blockPos, IBlockState blockState, Random random) {
        if (random.nextInt(100) == 0) {
            float height = (float)this.getHeight(blockState) / 8.0f;
            double d0 = (double)blockPos.func_177958_n() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)blockPos.func_177956_o() + 0.0625f + height;
            double d2 = (double)blockPos.func_177952_p() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            float f1 = 0.1f - random.nextFloat() * 0.2f;
            float f2 = 0.1f - random.nextFloat() * 0.2f;
            float f3 = 0.1f - random.nextFloat() * 0.2f;
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, d0, d1, d2, (double)f1, (double)f2, (double)f3, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        return side == EnumFacing.UP || super.func_176225_a(world, blockPos, side);
    }

    public int quantityDropped(IBlockState blockState, int fortune, Random random) {
        return this.getHeight(blockState);
    }

    public boolean func_176200_f(World world, BlockPos blockPos) {
        return true;
    }

    public void func_176204_a(World world, BlockPos blockPos, IBlockState blockState, Block neighbourBlock) {
        if (!this.func_176196_c(world, blockPos)) {
            world.func_175698_g(blockPos);
        }
    }

    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPig) {
                if (this.isChanceWithHeight(world, blockPos)) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76432_h.field_76415_H, 60, 1));
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
                }
            } else if ((entity instanceof EntityPlayer || ExcrementPileConfig.poisonEntities) && this.isChanceWithHeight(world, blockPos)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 1));
            }
        }
        super.func_176199_a(world, blockPos, entity);
    }

    private boolean isChanceWithHeight(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        float height = (float)this.getHeight(blockState) * 0.125f;
        return world.field_73012_v.nextFloat() * 10.0f < height;
    }

    public boolean canHeightenPileAt(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        return this.getHeight(blockState) < 8;
    }

    public void heightenPileAt(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        int height = this.getHeight(blockState);
        if (height < 8) {
            world.func_180501_a(blockPos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(height + 1)), 2);
        }
    }
}

