/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.core.helper.RenderHelpers;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class RenderTileEntityDarkTank
extends TileEntitySpecialRenderer {
    private static final double OFFSET = 0.01;
    private static final double MINY = 0.002;
    private static final double MIN = 0.135;
    private static final double MAX = 0.865;
    private static double[][][] coordinates = new double[][][]{new double[][]{{0.135, 0.002, 0.135}, {0.135, 0.002, 0.865}, {0.865, 0.002, 0.865}, {0.865, 0.002, 0.135}}, new double[][]{{0.135, 0.865, 0.135}, {0.135, 0.865, 0.865}, {0.865, 0.865, 0.865}, {0.865, 0.865, 0.135}}, new double[][]{{0.135, 0.002, 0.135}, {0.135, 0.865, 0.135}, {0.865, 0.865, 0.135}, {0.865, 0.002, 0.135}}, new double[][]{{0.135, 0.002, 0.865}, {0.135, 0.865, 0.865}, {0.865, 0.865, 0.865}, {0.865, 0.002, 0.865}}, new double[][]{{0.135, 0.002, 0.135}, {0.135, 0.865, 0.135}, {0.135, 0.865, 0.865}, {0.135, 0.002, 0.865}}, new double[][]{{0.865, 0.002, 0.135}, {0.865, 0.865, 0.135}, {0.865, 0.865, 0.865}, {0.865, 0.002, 0.865}}};

    public void func_180535_a(final TileEntity tileEntity, double x, double y, double z, float f, int partialDamage) {
        if (tileEntity instanceof TileDarkTank) {
            final TileDarkTank tank = (TileDarkTank)tileEntity;
            FluidStack fluid = tank.getTank().getFluid();
            org.cyclops.evilcraft.core.helper.RenderHelpers.renderTileFluidContext(fluid, x, y, z, tileEntity, new RenderHelpers.IFluidContextRender(){

                @Override
                public void renderFluid(FluidStack fluid) {
                    double height = tank.getFillRatio() * 0.99;
                    RenderTileEntityDarkTank.renderFluidSides(height, fluid, tileEntity.func_145831_w().func_175626_b(tileEntity.func_174877_v(), fluid.getFluid().getLuminosity(fluid)));
                }
            });
        }
    }

    public static void renderFluidSides(double height, FluidStack fluid, int brightness) {
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        for (EnumFacing side : DirectionHelpers.DIRECTIONS) {
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (EnumFacing)side);
            Tessellator t = Tessellator.func_178181_a();
            WorldRenderer worldRenderer = t.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            double[][] c = coordinates[side.ordinal()];
            double replacedMaxV = side == EnumFacing.UP || side == EnumFacing.DOWN ? (double)icon.func_94210_h() : (double)(icon.func_94210_h() - icon.func_94206_g()) * height + (double)icon.func_94206_g();
            worldRenderer.func_181662_b(c[0][0], RenderTileEntityDarkTank.getHeight(side, c[0][1], height), c[0][2]).func_181673_a((double)icon.func_94209_e(), replacedMaxV).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b(c[1][0], RenderTileEntityDarkTank.getHeight(side, c[1][1], height), c[1][2]).func_181673_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b(c[2][0], RenderTileEntityDarkTank.getHeight(side, c[2][1], height), c[2][2]).func_181673_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b(c[3][0], RenderTileEntityDarkTank.getHeight(side, c[3][1], height), c[3][2]).func_181673_a((double)icon.func_94212_f(), replacedMaxV).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            t.func_78381_a();
        }
    }

    private static double getHeight(EnumFacing side, double height, double replaceHeight) {
        if (height == 0.865) {
            return replaceHeight;
        }
        return height;
    }
}

