/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.block;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.evilcraft.core.algorithm.Dimension;
import org.cyclops.evilcraft.core.block.AllowedBlock;

public class CubeDetector {
    private static Vec3i NULL_SIZE = Vec3i.field_177959_e;
    private Collection<AllowedBlock> allowedBlocks = Sets.newHashSet();
    private Map<Block, AllowedBlock> blockInfo = Maps.newHashMap();
    private List<? extends IDetectionListener> listeners;
    private Vec3i minimumSize = NULL_SIZE;
    private Vec3i exactSize = NULL_SIZE;
    private Map<Block, Integer> blockOccurences;

    public CubeDetector(AllowedBlock[] allowedBlocks, List<? extends IDetectionListener> listeners) {
        this.addAllowedBlocks(allowedBlocks);
        this.listeners = listeners;
    }

    public Collection<AllowedBlock> getAllowedBlocks() {
        return this.allowedBlocks;
    }

    public void addAllowedBlocks(AllowedBlock[] allowedBlocks) {
        for (AllowedBlock block : allowedBlocks) {
            this.blockInfo.put(block.getBlock(), block);
            this.allowedBlocks.add(block);
        }
    }

    public Vec3i getMinimumSize() {
        return this.minimumSize;
    }

    public CubeDetector setMinimumSize(Vec3i minimumSize) {
        this.minimumSize = minimumSize;
        if (this.getExactSize() != NULL_SIZE) {
            throw new IllegalStateException("Can not set both a minimum and exact size.");
        }
        return this;
    }

    public Vec3i getExactSize() {
        return this.exactSize;
    }

    public CubeDetector setExactSize(Vec3i exactSize) {
        this.exactSize = exactSize;
        if (this.getMinimumSize() != NULL_SIZE) {
            throw new IllegalStateException("Can not set both a minimum and exact size.");
        }
        return this;
    }

    public List<? extends IDetectionListener> getListeners() {
        return this.listeners;
    }

    protected void notifyListeners(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        for (IDetectionListener iDetectionListener : this.getListeners()) {
            iDetectionListener.onDetect(world, location, size, valid, originCorner);
        }
    }

    protected boolean isValidLocation(World world, BlockPos location, IValidationAction action, BlockPos excludeLocation) {
        boolean contains;
        Block block = world.func_180495_p(location).func_177230_c();
        boolean bl = contains = location.equals((Object)excludeLocation) || this.blockInfo.containsKey(block);
        if (contains && action != null) {
            action.onValidate(location, block);
        }
        return contains;
    }

    protected boolean isValidLocation(World world, BlockPos location, BlockPos excludeLocation) {
        return this.isValidLocation(world, location, null, excludeLocation);
    }

    protected boolean isAir(World world, BlockPos location) {
        return world.func_175623_d(location);
    }

    protected BlockPos navigateToBorder(World world, BlockPos startLocation, int dimension, int direction, BlockPos excludeLocation) {
        BlockPos loopLocation = LocationHelpers.copyLocation((BlockPos)startLocation);
        while (this.isValidLocation(world, loopLocation, excludeLocation)) {
            loopLocation = LocationHelpers.addToDimension((BlockPos)loopLocation, (int)dimension, (int)direction);
        }
        loopLocation = LocationHelpers.addToDimension((BlockPos)loopLocation, (int)dimension, (int)(-direction));
        return loopLocation;
    }

    protected BlockPos navigateToBorder(World world, BlockPos startLocation, int dimension, boolean max, BlockPos excludeLocation) {
        return this.navigateToBorder(world, startLocation, dimension, max ? 1 : -1, excludeLocation);
    }

    protected BlockPos navigateToCorner(World world, BlockPos startLocation, int[] dimensions, boolean max, BlockPos excludeLocation) {
        BlockPos navigateLocation = LocationHelpers.copyLocation((BlockPos)startLocation);
        for (int dimension : dimensions) {
            navigateLocation = this.navigateToBorder(world, navigateLocation, dimension, max, excludeLocation);
        }
        return navigateLocation;
    }

    protected boolean isEdge(World world, int[][] dimensionEgdes, BlockPos location) {
        int[] c = LocationHelpers.toArray((Vec3i)location);
        for (int i = 0; i < dimensionEgdes.length; ++i) {
            for (int j = 0; j < dimensionEgdes[i].length; ++j) {
                if (dimensionEgdes[i][j] != c[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateLocationInStructure(World world, int[][] dimensionEgdes, BlockPos location, IValidationAction action, BlockPos excludeLocation) {
        return this.isValidLocation(world, location, action, excludeLocation);
    }

    protected boolean coordinateRecursion(World world, int[][] dimensionEgdes, BlockPosAction locationAction) {
        return this.coordinateRecursion(world, dimensionEgdes, new int[0], locationAction);
    }

    protected boolean coordinateRecursion(World world, int[][] dimensionEgdes, int[] accumulatedCoordinates, BlockPosAction locationAction) {
        if (accumulatedCoordinates.length == dimensionEgdes.length) {
            BlockPos location = LocationHelpers.fromArray((int[])accumulatedCoordinates);
            if (!locationAction.run(world, location)) {
                return false;
            }
        } else {
            int dimension = accumulatedCoordinates.length;
            int i = dimensionEgdes[dimension][0];
            while (i <= dimensionEgdes[dimension][1]) {
                int[] newAccumulatedCoordinates = Arrays.copyOf(accumulatedCoordinates, accumulatedCoordinates.length + 1);
                newAccumulatedCoordinates[accumulatedCoordinates.length] = i++;
                if (this.coordinateRecursion(world, dimensionEgdes, newAccumulatedCoordinates, locationAction)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateAllowedBlockConditions(World world, BlockPos location) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (this.blockInfo.containsKey(block)) {
            int occurences = this.blockOccurences.get(block);
            AllowedBlock allowed = this.blockInfo.get(block);
            if (allowed.getMaxOccurences() >= 0 && occurences >= allowed.getMaxOccurences()) {
                return false;
            }
            this.blockOccurences.put(block, occurences + 1);
        }
        return true;
    }

    protected boolean validateDimensionEdges(World world, final int[][] dimensionEgdes, final boolean valid, final IValidationAction action, final BlockPos excludeLocation) {
        this.blockOccurences = Maps.newHashMap();
        for (AllowedBlock block : this.allowedBlocks) {
            this.blockOccurences.put(block.getBlock(), 0);
        }
        boolean minimumValid = this.coordinateRecursion(world, dimensionEgdes, new BlockPosAction(){

            @Override
            public boolean run(World world, BlockPos location) {
                return (!valid || CubeDetector.this.validateAllowedBlockConditions(world, location)) && CubeDetector.this.validateLocationInStructure(world, dimensionEgdes, location, action, excludeLocation);
            }
        });
        if (minimumValid) {
            for (AllowedBlock allowed : this.allowedBlocks) {
                int occurences = this.blockOccurences.get(allowed.getBlock());
                if (allowed.getExactOccurences() < 0 || occurences == allowed.getExactOccurences()) continue;
                return !valid;
            }
        }
        return minimumValid;
    }

    protected void postValidate(World world, final Vec3i size, int[][] dimensionEgdes, final boolean valid, final BlockPos originCorner, BlockPos excludeLocation) {
        this.coordinateRecursion(world, dimensionEgdes, new BlockPosAction(){

            @Override
            public boolean run(World world, BlockPos location) {
                CubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                return true;
            }
        });
    }

    public Vec3i detect(World world, BlockPos startLocation, BlockPos excludeLocation, boolean changeState) {
        return this.detect(world, startLocation, excludeLocation, null, changeState);
    }

    public Vec3i detect(World world, BlockPos startLocation, BlockPos excludeLocation, IValidationAction action, boolean changeState) {
        if (!this.isValidLocation(world, startLocation, excludeLocation)) {
            return LocationHelpers.copyLocation((Vec3i)NULL_SIZE);
        }
        BlockPos tempOriginCorner = this.navigateToCorner(world, startLocation, new int[]{2, 1, 0}, true, excludeLocation);
        BlockPos originCorner = this.navigateToCorner(world, tempOriginCorner, new int[]{0, 1, 2}, false, excludeLocation);
        BlockPos[] corners = new BlockPos[Dimension.DIMENSIONS.length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = this.navigateToCorner(world, originCorner, new int[]{i}, true, excludeLocation);
        }
        int[] distances = new int[corners.length];
        int[][] dimensionEgdes = new int[corners.length][2];
        int[] cOriginCorner = LocationHelpers.toArray((Vec3i)originCorner);
        for (int i = 0; i < corners.length; ++i) {
            int[] cCorner = LocationHelpers.toArray((Vec3i)corners[i]);
            BlockPos sizeDifference = LocationHelpers.subtract((BlockPos)corners[i], (Vec3i)originCorner);
            distances[i] = LocationHelpers.toArray((Vec3i)sizeDifference)[i];
            int addIndex = 0;
            if (cOriginCorner[i] > cCorner[i]) {
                addIndex = 1;
            }
            dimensionEgdes[i][(0 + addIndex) % 2] = cOriginCorner[i];
            dimensionEgdes[i][(1 + addIndex) % 2] = cCorner[i];
        }
        if (!this.validateDimensionEdges(world, dimensionEgdes, excludeLocation == null, action, excludeLocation)) {
            return LocationHelpers.copyLocation((Vec3i)NULL_SIZE);
        }
        BlockPos size = LocationHelpers.fromArray((int[])distances);
        if (this.getMinimumSize() != NULL_SIZE && this.compareVec3i((Vec3i)size, this.getMinimumSize()) < 0 && excludeLocation == null) {
            return LocationHelpers.copyLocation((Vec3i)NULL_SIZE);
        }
        if (this.getExactSize() != NULL_SIZE && this.compareVec3i((Vec3i)size, this.getExactSize()) != 0 && excludeLocation == null) {
            return LocationHelpers.copyLocation((Vec3i)NULL_SIZE);
        }
        if (changeState) {
            this.postValidate(world, (Vec3i)size, dimensionEgdes, excludeLocation == null, originCorner, excludeLocation);
        }
        return size;
    }

    protected int compareVec3i(Vec3i vec1, Vec3i vec2) {
        boolean validBuffer = false;
        int buffer = Integer.MAX_VALUE;
        int[] v1 = LocationHelpers.toArray((Vec3i)vec1);
        int[] v2 = LocationHelpers.toArray((Vec3i)vec2);
        for (int i = 0; i < 3; ++i) {
            if (v1[i] == v2[i]) continue;
            int comp = v1[i] - v2[i];
            if (comp < 0) {
                return comp;
            }
            validBuffer = true;
            buffer = Math.min(buffer, comp);
        }
        return validBuffer ? buffer : 0;
    }

    public static interface IValidationAction {
        public void onValidate(BlockPos var1, Block var2);
    }

    protected static interface BlockPosAction {
        public boolean run(World var1, BlockPos var2);
    }

    public static interface IDetectionListener {
        public void onDetect(World var1, BlockPos var2, Vec3i var3, boolean var4, BlockPos var5);
    }
}

