/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.block.component;

import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.block.IBlockTank;

public class BlockTankComponent<T extends BlockContainer> {
    private T tank;

    public BlockTankComponent(T tank) {
        this.tank = tank;
    }

    public boolean onBlockActivatedTank(World world, BlockPos blockPos, EntityPlayer player, EnumFacing side, float motionX, float motionY, float motionZ) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_175625_s(blockPos);
        if (tile != null && itemStack != null) {
            ItemStack filledItem;
            FluidStack filledAmount;
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
            if (fluidStack != null) {
                if (BlockTankComponent.canTankBeFilled(tile, fluidStack) && tile.getTank().canCompletelyFill(fluidStack)) {
                    tile.fill(fluidStack, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack drainedItem = FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack);
                        if (drainedItem.field_77994_a == 0) {
                            drainedItem = null;
                        }
                        InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)drainedItem);
                    }
                }
                return true;
            }
            if (tile.getTank().getFluidAmount() > 0 && (filledAmount = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filledItem = FluidContainerRegistry.fillFluidContainer((FluidStack)tile.getTank().getFluid(), (ItemStack)itemStack)))) != null) {
                tile.drain(filledAmount, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)filledItem);
                }
                return true;
            }
            if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
                FluidStack fluidStackTemp;
                IFluidContainerItem containerItem = (IFluidContainerItem)itemStack.func_77973_b();
                fluidStack = containerItem.getFluid(itemStack);
                if (player.func_70093_af()) {
                    if (tile.getTank().getFluidAmount() > 0 && containerItem.fill(itemStack, fluidStackTemp = new FluidStack(tile.getTank().getFluid().getFluid(), 1000), false) > 0) {
                        tile.getTank().drain(containerItem.fill(itemStack, fluidStackTemp, true), true);
                    }
                } else if (fluidStack != null) {
                    fluidStackTemp = new FluidStack(fluidStack.getFluid(), Math.min(1000, fluidStack.amount));
                    if (BlockTankComponent.canTankBeFilled(tile, fluidStack) && tile.getTank().fill(fluidStackTemp, false) > 0) {
                        containerItem.drain(itemStack, tile.fill(fluidStackTemp, true), true);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected static boolean canTankBeFilled(TankInventoryTileEntity tile, FluidStack fluidStack) {
        return tile.getTank().getAcceptedFluid() == null || fluidStack == null || tile.getTank().getFluidType() == null || tile.getTank().canTankAccept(fluidStack.getFluid());
    }

    public String getInfoTank(ItemStack itemStack) {
        int amount = 0;
        FluidStack fluidStack = null;
        if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
            fluidStack = ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack);
        } else if (itemStack.func_77978_p() != null) {
            fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_77978_p().func_74775_l(((IBlockTank)this.tank).getTankNBTName()));
        }
        if (fluidStack != null) {
            amount = fluidStack.amount;
        }
        return DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)((IBlockTank)this.tank).getTankCapacity(itemStack));
    }

    public void writeAdditionalInfo(TileEntity tile, NBTTagCompound tag) {
        if (tile instanceof TankInventoryTileEntity) {
            TankInventoryTileEntity tankTile = (TankInventoryTileEntity)tile;
            ((IBlockTank)this.tank).setTankCapacity(tag, tankTile.getTank().getCapacity());
        }
    }
}

