/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.api.broom.IBroomPartRegistry;

public class BroomPartRegistry
implements IBroomPartRegistry {
    private final Set<IBroomPart> parts = Sets.newHashSet();
    private final Multimap<IBroomPart.BroomPartType, IBroomPart> partsByType = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
    @SideOnly(value=Side.CLIENT)
    private Map<IBroomPart, ResourceLocation> partModels;

    public BroomPartRegistry() {
        if (MinecraftHelpers.isClientSide()) {
            this.partModels = Maps.newHashMap();
        }
    }

    @Override
    public <P extends IBroomPart> P registerPart(P part) {
        this.parts.add(part);
        this.partsByType.put((Object)part.getType(), part);
        return part;
    }

    @Override
    public Collection<IBroomPart> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    @Override
    public Collection<IBroomPart> getParts(IBroomPart.BroomPartType type) {
        return Collections.unmodifiableCollection(this.partsByType.get((Object)type));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerPartModel(IBroomPart part, ResourceLocation modelLocation) {
        this.partModels.put(part, modelLocation);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getPartModel(IBroomPart part) {
        return this.partModels.get(part);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Collection<ResourceLocation> getPartModels() {
        return Collections.unmodifiableCollection(this.partModels.values());
    }
}

