/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.config.configurable;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.core.tileentity.InnerBlocksTileEntity;

public abstract class ConfigurableBlockWithInnerBlocksExtended
extends ConfigurableBlockContainer {
    public ConfigurableBlockWithInnerBlocksExtended(ExtendedConfig eConfig, Material material, Class<? extends InnerBlocksTileEntity> tileEntity) {
        super(eConfig, material, tileEntity);
        this.setRotatable(false);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
    }

    public boolean saveNBTToDroppedItem() {
        return false;
    }

    public InnerBlocksTileEntity getTile(IBlockAccess world, BlockPos blockPos) throws InvalidInnerBlocksTileException {
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile == null || !(tile instanceof InnerBlocksTileEntity)) {
            throw new InvalidInnerBlocksTileException();
        }
        return (InnerBlocksTileEntity)tile;
    }

    public boolean removedByPlayer(World world, BlockPos blockPos, EntityPlayer player, boolean willHarvest) {
        this.unwrapInnerBlock(world, blockPos);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess world, BlockPos blockPos, int renderPass) {
        try {
            return this.getTile(world, blockPos).getInnerBlockState().func_177230_c().func_180662_a(world, blockPos, renderPass);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_176202_d(world, blockPos);
        }
        catch (NullPointerException e) {
            return Blocks.field_150348_b.func_176202_d(world, blockPos);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.func_176202_d(world, blockPos);
        }
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos blockPos, EntityPlayer player) {
        try {
            return this.getTile(world, blockPos).getInnerBlockState().func_177230_c().canHarvestBlock(world, blockPos, player);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.canHarvestBlock(world, blockPos, player);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.canHarvestBlock(world, blockPos, player);
        }
    }

    public float func_176195_g(World world, BlockPos blockPos) {
        try {
            return this.getTile((IBlockAccess)world, blockPos).getInnerBlockState().func_177230_c().func_176195_g(world, blockPos);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_176195_g(world, blockPos);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.func_176195_g(world, blockPos);
        }
    }

    public float func_180647_a(EntityPlayer player, World world, BlockPos blockPos) {
        try {
            return this.getTile((IBlockAccess)world, blockPos).getInnerBlockState().func_177230_c().func_180647_a(player, world, blockPos);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_180647_a(player, world, blockPos);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.func_180647_a(player, world, blockPos);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos blockPos) {
        IBlockState blockState;
        try {
            blockState = this.getTile((IBlockAccess)world, blockPos).getInnerBlockState();
            if (blockState == null) {
                blockState = Blocks.field_150348_b.func_176223_P();
            }
        }
        catch (InvalidInnerBlocksTileException e) {
            blockState = Blocks.field_150348_b.func_176223_P();
        }
        return new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
    }

    public boolean setInnerBlock(World world, BlockPos blockPos) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (this.canSetInnerBlock(block, (IBlockAccess)world, blockPos)) {
            IBlockState state = world.func_180495_p(blockPos);
            world.func_180501_a(blockPos, this.func_176223_P(), 2);
            try {
                this.getTile((IBlockAccess)world, blockPos).setInnerBlockState(state);
            }
            catch (InvalidInnerBlocksTileException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public IBlockState unwrapInnerBlock(World world, BlockPos blockPos) {
        InnerBlocksTileEntity tile = null;
        try {
            tile = this.getTile((IBlockAccess)world, blockPos);
        }
        catch (InvalidInnerBlocksTileException e) {
            e.printStackTrace();
        }
        if (tile == null) {
            return null;
        }
        IBlockState block = tile.getInnerBlockState();
        if (block == null) {
            return null;
        }
        IBlockState state = world.func_180495_p(blockPos);
        world.func_180501_a(blockPos, block, 2);
        return state;
    }

    public boolean canSetInnerBlock(Block block, IBlockAccess world, BlockPos blockPos) {
        return block != null && !block.isAir(world, blockPos) && block.func_149662_c() && !block.hasTileEntity(world.func_180495_p(blockPos)) && block.func_149645_b() == 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IBlockState blockState;
        try {
            blockState = this.getTile((IBlockAccess)worldObj, target.func_178782_a()).getInnerBlockState();
        }
        catch (InvalidInnerBlocksTileException e) {
            blockState = Blocks.field_150348_b.func_176223_P();
        }
        BlockPos pos = target.func_178782_a();
        RenderHelpers.addBlockHitEffects((EffectRenderer)effectRenderer, (World)worldObj, (IBlockState)blockState, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        return true;
    }

    public static class InvalidInnerBlocksTileException
    extends Exception {
    }
}

