/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableDegradationEffect;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.item.MaceOfDistortion;

public class KnockbackDistortDegradation
extends ConfigurableDegradationEffect {
    private static KnockbackDistortDegradation _instance = null;
    private static final int MINIMUM_DEGRADATION = 3;
    private static final int POWER_LEVEL = 1;

    public static KnockbackDistortDegradation getInstance() {
        return _instance;
    }

    public KnockbackDistortDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig);
    }

    @Override
    public boolean canRun(IDegradable degradable) {
        return degradable.getDegradation() >= 3.0;
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        List<Entity> entities = degradable.getAreaEntities();
        BlockPos center = degradable.getLocation();
        double x = center.func_177958_n();
        double y = center.func_177956_o();
        double z = center.func_177952_p();
        for (Entity entity : entities) {
            MaceOfDistortion.getInstance().distortEntity(degradable.getDegradationWorld(), null, entity, x, y, z, (int)degradable.getDegradation() * 10, 1);
        }
    }
}

