/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.cyclops.evilcraft.GeneralConfig;

public class ItemHelpers {
    private static final int MB_FILL_PERTICK = GeneralConfig.mbFlowRate;

    public static boolean isActivated(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("enabled");
    }

    public static void toggleActivation(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        tag.func_74757_a("enabled", !ItemHelpers.isActivated(itemStack));
    }

    public static int getNBTInt(ItemStack itemStack, String tag) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return 0;
        }
        return itemStack.func_77978_p().func_74762_e(tag);
    }

    public static void setNBTInt(ItemStack itemStack, int integer, String tag) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a(tag, integer);
    }

    public static void updateAutoFill(IFluidContainerItem item, ItemStack itemStack, World world, Entity entity) {
        FluidStack tickFluid;
        if (entity instanceof EntityPlayer && !world.field_72995_K && (tickFluid = item.getFluid(itemStack)) != null && tickFluid.amount > 0) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack held = player.func_71045_bC();
            ItemHelpers.tryFillContainerForPlayer(item, itemStack, held, tickFluid, player);
        }
    }

    public static void tryFillContainerForPlayer(IFluidContainerItem item, ItemStack itemStack, ItemStack toFill, FluidStack tickFluid, EntityPlayer player) {
        IFluidContainerItem fluidContainer;
        FluidStack heldFluid;
        if (toFill != null && toFill != itemStack && toFill.func_77973_b() instanceof IFluidContainerItem && !player.func_71039_bw() && ((heldFluid = (fluidContainer = (IFluidContainerItem)toFill.func_77973_b()).getFluid(toFill)) == null || heldFluid.isFluidEqual(tickFluid) && heldFluid.amount < fluidContainer.getCapacity(toFill))) {
            int filled = fluidContainer.fill(toFill, new FluidStack(tickFluid.getFluid(), Math.min(tickFluid.amount, MB_FILL_PERTICK)), true);
            item.drain(itemStack, filled, true);
        }
    }
}

