/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.custom;

import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.recipe.custom.DurationRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.IDurationRecipeProperties;
import org.cyclops.evilcraft.tileentity.environmentalaccumulator.IEAProcessingFinishedEffect;

public class EnvironmentalAccumulatorRecipeProperties
implements IRecipeProperties,
IDurationRecipeProperties {
    private final double processingSpeed;
    private final int cooldownTime;
    private final IEAProcessingFinishedEffect finishedProcessingEffect;
    private final DurationRecipeProperties duration;
    private final IEAResultOverride resultOverride;

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime, double processingSpeed, IEAProcessingFinishedEffect finishedProcessingEffect, IEAResultOverride resultOverride) {
        this.duration = new DurationRecipeProperties(duration);
        this.processingSpeed = processingSpeed;
        this.cooldownTime = cooldownTime;
        this.finishedProcessingEffect = finishedProcessingEffect;
        this.resultOverride = resultOverride;
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime, double processingSpeed, IEAProcessingFinishedEffect finishedProcessingEffect) {
        this(duration, cooldownTime, processingSpeed, finishedProcessingEffect, new IEAResultOverride(){

            @Override
            public ItemStack getResult(IBlockAccess world, BlockPos pos, ItemStack originalResult) {
                return originalResult;
            }
        });
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime, double processingSpeed) {
        this(duration, cooldownTime, processingSpeed, null);
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime) {
        this(duration, cooldownTime, -1.0);
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration) {
        this(duration, -1);
    }

    public EnvironmentalAccumulatorRecipeProperties() {
        this(-1);
    }

    public double getProcessingSpeed() {
        if (this.processingSpeed < 0.0) {
            return EnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return this.processingSpeed;
    }

    public int getCooldownTime() {
        if (this.cooldownTime < 0) {
            return EnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return this.cooldownTime;
    }

    @Override
    public int getDuration() {
        if (this.duration.getDuration() < 0) {
            return EnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.duration.getDuration();
    }

    public IEAProcessingFinishedEffect getFinishedProcessingEffect() {
        return this.finishedProcessingEffect;
    }

    public IEAResultOverride getResultOverride() {
        return this.resultOverride;
    }

    public static interface IEAResultOverride {
        public ItemStack getResult(IBlockAccess var1, BlockPos var2, ItemStack var3);
    }
}

