/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.tileentity.tickaction;

import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;

public class TickComponent<C extends CyclopsTileEntity, T extends ITickAction<C>> {
    private Map<Class<?>, T> tickActions;
    private C tile;
    private boolean redstoneDisableable;
    private int tick = 0;
    private float requiredTicks = 0.0f;
    private int slot;

    public TickComponent(C tile, Map<Class<?>, T> tickActions, int slot, boolean redstoneDisableable) {
        this.tile = tile;
        this.tickActions = tickActions;
        this.slot = slot;
        this.redstoneDisableable = redstoneDisableable;
    }

    public TickComponent(C tile, Map<Class<?>, T> tickActions, int slot) {
        this(tile, tickActions, slot, true);
    }

    protected T getTickAction(Item item) {
        for (Map.Entry<Class<?>, T> entry : this.tickActions.entrySet()) {
            Item instance = item;
            if (entry.getKey().isInstance(instance)) {
                return (T)((ITickAction)entry.getValue());
            }
            if (!(item instanceof ItemBlock)) continue;
            instance = ((ItemBlock)item).func_179223_d();
            if (!entry.getKey().isInstance(instance)) continue;
            return (T)((ITickAction)entry.getValue());
        }
        return null;
    }

    public void tick(ItemStack itemStack, int slot) {
        if (itemStack != null) {
            C action = this.getTickAction(itemStack.func_77973_b());
            if (action != null) {
                if (action.canTick(this.tile, itemStack, slot, this.tick)) {
                    if (this.tick == 0) {
                        this.requiredTicks = action.getRequiredTicks(this.tile, slot, this.tick);
                    }
                    ++this.tick;
                    int repeatFor = this.requiredTicks == 0.0f ? 1 : Math.max(1, (int)Math.ceil(1.0f / this.requiredTicks));
                    for (int i = 0; i < repeatFor; ++i) {
                        action.onTick(this.tile, itemStack, slot, this.tick);
                    }
                    if ((float)this.tick >= this.requiredTicks) {
                        this.tick = 0;
                    }
                }
            } else {
                this.tick = 0;
            }
        } else {
            this.tick = 0;
        }
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public float getRequiredTicks() {
        return this.requiredTicks;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setRequiredTicks(float requiredTicks) {
        this.requiredTicks = requiredTicks;
    }

    public boolean isRedstoneDisableable() {
        return this.redstoneDisableable;
    }
}

