/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.client.particle.EntityBlurFX;
import org.cyclops.evilcraft.core.algorithm.OrganicSpread;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.BiomeExtract;
import org.cyclops.evilcraft.item.BiomeExtractConfig;

public class EntityBiomeExtract
extends EntityThrowable
implements IConfigurable {
    private static final int ITEMSTACK_INDEX = 15;

    public EntityBiomeExtract(World world) {
        super(world);
    }

    public EntityBiomeExtract(World world, EntityLivingBase entity, int damage) {
        this(world, entity, new ItemStack((Item)(Configs.isEnabled(BiomeExtractConfig.class) ? BiomeExtract.getInstance() : Items.field_151044_h), 1, damage));
    }

    public EntityBiomeExtract(World world, EntityLivingBase entity, ItemStack stack) {
        super(world, entity);
        this.setItemStack(stack);
    }

    protected void func_70184_a(final MovingObjectPosition movingobjectposition) {
        ItemStack itemStack = this.getItemStack();
        final BiomeGenBase biome = BiomeExtract.getInstance().getBiome(itemStack);
        if (biome != null) {
            OrganicSpread spread = new OrganicSpread(this.field_70170_p, 2, 5, new OrganicSpread.IOrganicSpreadable(){

                @Override
                public boolean isDone(World world, BlockPos location) {
                    return world.func_180494_b(location) == biome;
                }

                @Override
                public void spreadTo(World world, BlockPos location) {
                    if (EntityBiomeExtract.this.field_70170_p.field_72995_K) {
                        EntityBiomeExtract.this.showChangedBiome(EntityBiomeExtract.this.field_70170_p, new BlockPos(location.func_177958_n(), movingobjectposition.func_178782_a().func_177956_o(), location.func_177952_p()), biome.field_76790_z);
                    } else {
                        WorldHelpers.setBiome((World)EntityBiomeExtract.this.field_70170_p, (BlockPos)location, (BiomeGenBase)biome);
                    }
                }
            });
            for (int i = 0; i < 50; ++i) {
                spread.spreadTick(movingobjectposition.func_178782_a());
            }
        }
        this.field_70170_p.func_175718_b(2002, this.func_180425_c(), 16428);
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    private void showChangedBiome(World world, BlockPos pos, int color) {
        Triple c = Helpers.intToRGB((int)color);
        Random rand = world.field_73012_v;
        for (int j = 0; j < 2 + rand.nextInt(5); ++j) {
            float x = (float)pos.func_177958_n() + -0.5f + rand.nextFloat();
            float y = (float)pos.func_177956_o() + -0.5f + rand.nextFloat();
            float z = (float)pos.func_177952_p() + -0.5f + rand.nextFloat();
            float scale = 0.2f - rand.nextFloat() * 0.2f;
            float red = ((Float)c.getLeft()).floatValue() + rand.nextFloat() * 0.1f;
            float green = ((Float)c.getMiddle()).floatValue() + rand.nextFloat() * 0.1f;
            float blue = ((Float)c.getRight()).floatValue() + rand.nextFloat() * 0.1f;
            float ageMultiplier = 10 + rand.nextInt(15);
            double motionX = -0.1f + rand.nextFloat() * 0.2f;
            double motionY = 0.1f + rand.nextFloat() * 0.2f;
            double motionZ = -0.1f + rand.nextFloat() * 0.2f;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityBlurFX(world, x, y, z, scale, motionX, motionY, motionZ, red, green, blue, ageMultiplier));
        }
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    protected float func_70183_g() {
        return 0.0f;
    }

    @Override
    public ItemStack getItemStack() {
        return this.field_70180_af.func_82710_f(15);
    }

    private void setItemStack(ItemStack stack) {
        this.field_70180_af.func_75692_b(15, (Object)stack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)BiomeExtract.getInstance().createItemStack(null, 1));
    }

    public ExtendedConfig<?> getConfig() {
        return null;
    }
}

