/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.entity.item.EntityBroomConfig;
import org.cyclops.evilcraft.item.Broom;
import org.cyclops.evilcraft.item.BroomConfig;

public class EntityBroom
extends Entity
implements IConfigurable {
    public static final double SPEED = 0.4;
    public static final float MAX_ANGLE = 45.0f;
    public static final float MIN_ANGLE = -45.0f;
    private static final float MAX_COS_AMPLITUDE = 0.2f;
    public EntityPlayer lastMounted = null;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    private int newPosRotationIncrements;
    private int broomHoverTickOffset;
    @SideOnly(value=Side.CLIENT)
    private double oldHoverOffset;

    public EntityBroom(World world) {
        this(world, 0.0, 0.0, 0.0);
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
        this.func_70105_a(1.5f, 0.6f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.initBroomHoverTickOffset();
    }

    protected void initBroomHoverTickOffset() {
        this.broomHoverTickOffset = this.field_70146_Z.nextInt(3);
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && this.field_70153_n == null;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.field_70153_n == null) {
            this.func_70078_a((Entity)player);
            return true;
        }
        return false;
    }

    public void func_70078_a(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.field_70153_n == null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_70078_a((Entity)this);
            this.lastMounted = player;
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean isTeleport) {
        posRotationIncrements += 6;
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yaw;
        this.newRotationPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
        if (this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71439_g == this.lastMounted) {
            double dx = this.newPosX - this.field_70165_t;
            double dy = this.newPosY - this.field_70163_u + this.oldHoverOffset;
            double dz = this.newPosZ - this.field_70161_v;
            boolean changePosition = false;
            if (Math.abs(dx) > EntityBroomConfig.desyncThreshold) {
                this.field_70165_t += dx * EntityBroomConfig.desyncCorrectionValue;
                changePosition = true;
            }
            if (Math.abs(dy) > EntityBroomConfig.desyncThreshold) {
                this.field_70163_u += dy * EntityBroomConfig.desyncCorrectionValue;
                changePosition = true;
            }
            if (Math.abs(dz) > EntityBroomConfig.desyncThreshold) {
                this.field_70161_v += dz * EntityBroomConfig.desyncCorrectionValue;
                changePosition = true;
            }
            if (changePosition) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70153_n == null && this.lastMounted != null) {
            if (!this.lastMounted.field_71075_bZ.field_75098_d && Configs.isEnabled(BroomConfig.class)) {
                if (!this.lastMounted.field_70128_L && !MinecraftHelpers.isPlayerInventoryFull((EntityPlayer)this.lastMounted)) {
                    this.lastMounted.field_71071_by.func_70441_a(new ItemStack((Item)Broom.getInstance(), 1));
                } else {
                    this.func_145779_a((Item)Broom.getInstance(), 1);
                }
            }
            this.lastMounted = null;
            this.field_70170_p.func_72900_e((Entity)this);
        } else if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            this.lastMounted = (EntityPlayer)this.field_70153_n;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            if (!this.field_70170_p.field_72995_K || Minecraft.func_71410_x().field_71439_g == this.lastMounted) {
                this.updateMountedServer();
            } else {
                this.updateMountedClient();
            }
        } else {
            this.updateUnmounted();
        }
    }

    protected void updateMountedClient() {
        if (this.newPosRotationIncrements > 0) {
            double x = this.field_70165_t + (this.newPosX - this.field_70165_t) / (double)this.newPosRotationIncrements;
            double y = this.field_70163_u + (this.newPosY - this.field_70163_u) / (double)this.newPosRotationIncrements;
            double z = this.field_70161_v + (this.newPosZ - this.field_70161_v) / (double)this.newPosRotationIncrements;
            float yaw = MathHelpers.normalizeAngle_180((float)(this.newRotationYaw - (double)this.field_70177_z));
            this.field_70177_z += yaw / (float)this.newPosRotationIncrements;
            this.field_70125_A = (float)((double)this.field_70125_A + (this.newRotationPitch - (double)this.field_70125_A) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.func_70091_d(0.0, this.getHoverOffset(), 0.0);
    }

    protected void updateMountedServer() {
        this.field_70125_A = MathHelpers.normalizeAngle_180(this.lastMounted.field_70125_A);
        this.field_70177_z = MathHelpers.normalizeAngle_180(this.lastMounted.field_70177_z);
        if (this.field_70125_A > 45.0f) {
            this.field_70125_A = 45.0f;
        } else if (this.field_70125_A < -45.0f) {
            this.field_70125_A = -45.0f;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        double pitch = (double)(this.field_70153_n.field_70125_A + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(this.field_70153_n.field_70177_z + 90.0f) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double z = Math.sin(pitch) * Math.sin(yaw);
        double y = Math.cos(pitch);
        if (this.lastMounted.field_70701_bs != 0.0f) {
            double playerSpeed = 10.0 * this.lastMounted.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.field_70159_w = x * 0.4 * playerSpeed * (double)this.lastMounted.field_70701_bs;
            this.field_70181_x = y * 0.4 * playerSpeed * (double)this.lastMounted.field_70701_bs;
            this.field_70179_y = z * 0.4 * playerSpeed * (double)this.lastMounted.field_70701_bs;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70181_x += this.getHoverOffset();
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2));
        if (list != null && !list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityBroom)) continue;
                entity.func_70108_f((Entity)this);
            }
        }
    }

    protected void updateUnmounted() {
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(0.0, this.getHoverOffset(), 0.0);
        }
    }

    protected double getHoverOffset() {
        float x = this.field_70170_p.func_72820_D();
        float t = this.broomHoverTickOffset;
        double newHoverOffset = Math.cos(x / 10.0f + t) * Math.cos(x / 12.0f + t) * Math.cos(x / 15.0f + t) * (double)0.2f;
        double newHoverDifference = newHoverOffset - this.oldHoverOffset;
        this.oldHoverOffset += newHoverDifference;
        return newHoverDifference;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public ExtendedConfig<?> getConfig() {
        return null;
    }
}

