/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.entity.item.EntityItemDefinedRotation;
import org.cyclops.evilcraft.world.gen.DarkTempleGenerator;

public class EntityItemDarkStick
extends EntityItemDefinedRotation {
    private static final int WATCHERID_VALID = 20;
    private static final int WATCHERID_ANGLE = 21;
    private double lastPosX = -1.0;
    private double lastPosY = -1.0;
    private double lastPosZ = -1.0;

    public EntityItemDarkStick(World world, EntityItem original) {
        super(world, original);
    }

    public EntityItemDarkStick(World world) {
        super(world);
    }

    public EntityItemDarkStick(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityItemDarkStick(World world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
    }

    public void func_70088_a() {
        super.func_70088_a();
        Float angle = MinecraftHelpers.isClientSide() ? null : this.loadRotation();
        this.field_70180_af.func_75682_a(20, (Object)(angle != null ? 1 : 0));
        this.field_70180_af.func_75682_a(21, (Object)Float.valueOf(angle == null ? 0.0f : angle.floatValue()));
    }

    protected boolean hasMoved() {
        boolean moved = Math.abs(this.lastPosX - this.field_70165_t) > (double)0.1f || Math.abs(this.lastPosZ - this.field_70161_v) > (double)0.1f;
        this.lastPosX = this.field_70165_t;
        this.lastPosY = this.field_70163_u;
        this.lastPosZ = this.field_70161_v;
        return moved;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!MinecraftHelpers.isClientSide() && this.hasMoved()) {
            Float angle = this.loadRotation();
            this.setValid(angle != null);
            this.setAngle(angle == null ? 0.0f : angle.floatValue());
        }
    }

    private Float loadRotation() {
        BlockPos closest = DarkTempleGenerator.getClosestForCoords(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
        if (closest != null) {
            double d = (closest = new BlockPos(closest.func_177958_n(), 0, closest.func_177952_p())).func_177951_i((Vec3i)new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v));
            if (d <= 32.0) {
                return null;
            }
            BlockPos normalized = new BlockPos(closest.func_177958_n() - (int)this.field_70165_t, 0, closest.func_177952_p() - (int)this.field_70161_v);
            return Float.valueOf((float)(Math.atan2(normalized.func_177958_n(), normalized.func_177952_p()) * 180.0 / Math.PI));
        }
        return null;
    }

    @Override
    protected boolean hasCustomRotation() {
        return this.isValid() && DarkTempleGenerator.canGenerate(this.func_130014_f_());
    }

    public float getAngle() {
        return this.field_70180_af.func_111145_d(21);
    }

    protected void setAngle(float angle) {
        this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(angle));
    }

    public boolean isValid() {
        return this.field_70180_af.func_75679_c(20) == 1;
    }

    protected void setValid(boolean valid) {
        this.field_70180_af.func_75692_b(20, (Object)(valid ? 1 : 0));
    }
}

