/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.MobConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.RenderPoisonousLibelle;
import org.cyclops.evilcraft.client.render.model.ModelPoisonousLibelle;
import org.cyclops.evilcraft.entity.monster.PoisonousLibelle;

public class PoisonousLibelleConfig
extends MobConfig {
    public static PoisonousLibelleConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="Should the Poisonous Libelle be enabled?", requiresMcRestart=true)
    public static boolean isEnabled;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="Should the Poisonous Libelle do damage, next to poisoning?", isCommandable=true)
    public static boolean hasAttackDamage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The minimum Y-level this mob can spawn at.", isCommandable=true)
    public static int minY;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="1/X chance on getting poisoned when hit.", isCommandable=true)
    public static int poisonChance;

    public PoisonousLibelleConfig() {
        super((ModBase)EvilCraft._instance, true, "poisonousLibelle", null, PoisonousLibelle.class);
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public int getBackgroundEggColor() {
        return Helpers.RGBToInt((int)57, (int)125, (int)27);
    }

    public int getForegroundEggColor() {
        return Helpers.RGBToInt((int)196, (int)213, (int)57);
    }

    @SideOnly(value=Side.CLIENT)
    public Render getRender(RenderManager renderManager) {
        return new RenderPoisonousLibelle(renderManager, (ExtendedConfig<MobConfig>)this, (ModelBase)new ModelPoisonousLibelle(), 0.5f);
    }

    public void onRegistered() {
        EntityRegistry.addSpawn(PoisonousLibelle.class, (int)1, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76781_i});
    }

    static {
        isEnabled = true;
        hasAttackDamage = false;
        minY = 55;
        poisonChance = 20;
    }
}

