/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.block.BloodStainedBlock;
import org.cyclops.evilcraft.block.BloodStainedBlockConfig;
import org.cyclops.evilcraft.block.SpiritPortal;
import org.cyclops.evilcraft.block.SpiritPortalConfig;
import org.cyclops.evilcraft.client.particle.EntityBloodSplashFX;
import org.cyclops.evilcraft.core.world.FakeWorld;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.VengeanceSpiritConfig;
import org.cyclops.evilcraft.item.BloodExtractor;
import org.cyclops.evilcraft.item.BloodExtractorConfig;
import org.cyclops.evilcraft.item.VeinSword;
import org.cyclops.evilcraft.item.VeinSwordConfig;
import org.cyclops.evilcraft.item.VengeanceRing;
import org.cyclops.evilcraft.item.VengeanceRingConfig;
import org.cyclops.evilcraft.item.WerewolfFlesh;
import org.cyclops.evilcraft.item.WerewolfFleshConfig;

public class LivingDeathEventHook {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        this.bloodObtainEvent(event);
        this.bloodStainedBlockEvent(event);
        this.vengeanceEvent(event);
        this.dropHumanoidFleshEvent(event);
        this.palingDeath(event);
    }

    private void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.source.func_76346_g();
        if (e != null && e instanceof EntityPlayerMP && !e.field_70170_p.field_72995_K && event.entityLiving != null && Configs.isEnabled(BloodExtractorConfig.class)) {
            float boost = 1.0f;
            EntityPlayerMP player = (EntityPlayerMP)e;
            if (Configs.isEnabled(VeinSwordConfig.class) && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == VeinSword.getInstance()) {
                boost = (float)VeinSwordConfig.extractionBoost;
            }
            float health = event.entityLiving.func_110138_aP();
            int minimumMB = MathHelper.func_76141_d((float)(health * (float)BloodExtractorConfig.minimumMobMultiplier * boost));
            int maximumMB = MathHelper.func_76141_d((float)(health * (float)BloodExtractorConfig.maximumMobMultiplier * boost));
            BloodExtractor.getInstance().fillForAllBloodExtractors((EntityPlayer)player, minimumMB, maximumMB);
        }
    }

    private void bloodStainedBlockEvent(LivingDeathEvent event) {
        if (event.source == DamageSource.field_76379_h && Configs.isEnabled(BloodStainedBlockConfig.class) && !(event.entity instanceof VengeanceSpirit)) {
            int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)(event.entity.field_70163_u - event.entity.func_70033_W() - 1.0));
            int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
            BlockPos pos = new BlockPos(x, y, z);
            Block block = event.entity.field_70170_p.func_180495_p(pos).func_177230_c();
            if (BloodStainedBlock.getInstance().canSetInnerBlock(block, (IBlockAccess)event.entity.field_70170_p, pos) || block == BloodStainedBlock.getInstance()) {
                if (!event.entity.field_70170_p.field_72995_K) {
                    BloodStainedBlock.getInstance().stainBlock(event.entity.field_70170_p, pos, (int)((float)BloodStainedBlockConfig.bloodMBPerHP * event.entityLiving.func_110138_aP()));
                } else {
                    Random random = new Random();
                    EntityBloodSplashFX.spawnParticles(event.entity.field_70170_p, pos.func_177982_a(0, 1, 0), (int)event.entityLiving.func_110138_aP() + random.nextInt(15), 5 + random.nextInt(5));
                }
            }
        }
    }

    private void vengeanceEvent(LivingDeathEvent event) {
        if (event.entityLiving != null) {
            World world = event.entityLiving.field_70170_p;
            boolean directToPlayer = this.shouldDirectSpiritToPlayer(event);
            if (!world.field_72995_K && !(world instanceof FakeWorld) && world.func_175659_aa() != EnumDifficulty.PEACEFUL && Configs.isEnabled(VengeanceSpiritConfig.class) && VengeanceSpirit.canSustain(event.entityLiving) && (directToPlayer || VengeanceSpirit.canSpawnNew(world, event.entityLiving.func_180425_c()))) {
                VengeanceSpirit spirit = new VengeanceSpirit(world);
                spirit.setInnerEntity(event.entityLiving);
                spirit.func_82149_j((Entity)event.entityLiving);
                world.func_72838_d((Entity)spirit);
                if (directToPlayer) {
                    EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
                    spirit.setBuildupDuration(60);
                    spirit.setGlobalVengeance(true);
                    spirit.func_70624_b((EntityLivingBase)player);
                }
            }
        }
    }

    private boolean shouldDirectSpiritToPlayer(LivingDeathEvent event) {
        if (event.source.func_76364_f() instanceof EntityPlayer && Configs.isEnabled(VengeanceRingConfig.class)) {
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            while (it.hasNext()) {
                ItemStack itemStack = it.next();
                if (itemStack == null || itemStack.func_77973_b() != VengeanceRing.getInstance()) continue;
                return true;
            }
        }
        return false;
    }

    private void dropHumanoidFleshEvent(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayerMP && Configs.isEnabled(WerewolfFleshConfig.class) && !event.entityLiving.field_70170_p.field_72995_K && event.entityLiving.field_70170_p.field_73012_v.nextInt(WerewolfFleshConfig.humanoidFleshDropChance) == 0) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityLiving;
            ItemStack itemStack = new ItemStack((Item)WerewolfFlesh.getInstance(), 1, 1);
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                itemStack.func_77982_d(tag);
            }
            NBTUtil.func_180708_a((NBTTagCompound)tag, (GameProfile)player.func_146103_bH());
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            EntityItem entity = new EntityItem(player.field_70170_p, x, y, z, itemStack);
            player.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    private void palingDeath(LivingDeathEvent event) {
        if (event.source == ExtendedDamageSource.paling && Configs.isEnabled(SpiritPortalConfig.class)) {
            SpiritPortal.tryPlacePortal(event.entityLiving.field_70170_p, event.entityLiving.func_180425_c().func_177982_a(0, 1, 0));
        }
    }
}

