/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.enchantment.EnchantmentBreaking;
import org.cyclops.evilcraft.enchantment.EnchantmentBreakingConfig;
import org.cyclops.evilcraft.enchantment.EnchantmentUnusing;
import org.cyclops.evilcraft.enchantment.EnchantmentUnusingConfig;

public class PlayerInteractEventHook {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.unusingEvent(event);
        this.breakingEvent(event);
    }

    private void unusingEvent(PlayerInteractEvent event) {
        if (Configs.isEnabled(EnchantmentUnusingConfig.class) && this.doesEnchantApply(event, EnchantmentUnusingConfig._instance.ID) > -1 && event.entityPlayer != null && EnchantmentUnusing.unuseTool(event.entityPlayer.func_71045_bC())) {
            event.setCanceled(true);
            event.entityPlayer.func_71034_by();
        }
    }

    private void breakingEvent(PlayerInteractEvent event) {
        if (Configs.isEnabled(EnchantmentBreakingConfig.class)) {
            int i = this.doesEnchantApply(event, EnchantmentBreakingConfig._instance.ID);
            ItemStack itemStack = event.entityPlayer.func_71045_bC();
            EnchantmentBreaking.amplifyDamage(itemStack, i, new Random());
        }
    }

    private int doesEnchantApply(PlayerInteractEvent event, int enchantID) {
        if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) && event.entityPlayer != null) {
            ItemStack itemStack = event.entityPlayer.func_71045_bC();
            return EnchantmentHelpers.doesEnchantApply((ItemStack)itemStack, (int)enchantID);
        }
        return -1;
    }
}

