/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.entity.item.EntityBiomeExtract;
import org.cyclops.evilcraft.item.BiomeExtractConfig;

public class BiomeExtract
extends ConfigurableItem {
    private static final String NBT_BIOMEID = "biomeId";
    private static BiomeExtract _instance = null;

    public static BiomeExtract getInstance() {
        return _instance;
    }

    public BiomeExtract(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (itemStack.func_77952_i() == 0 ? ".empty" : "");
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        if (renderPass == 0 && itemStack.func_77952_i() > 0) {
            BiomeGenBase biome = this.getBiome(itemStack);
            if (biome != null) {
                return biome.field_76790_z;
            }
            return Helpers.RGBToInt((int)125, (int)125, (int)125);
        }
        return 0xFFFFFF;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.getBiome(itemStack) != null && !BiomeExtractConfig._instance.isUsageBlacklisted(this.getBiome((ItemStack)itemStack).field_76756_M)) {
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            world.func_72838_d((Entity)new EntityBiomeExtract(world, (EntityLivingBase)player, itemStack.func_77946_l()));
            --itemStack.field_77994_a;
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        BiomeGenBase biome = this.getBiome(itemStack);
        if (biome != null) {
            list.add(L10NHelpers.localize((String)(this.func_77658_a() + ".info.content"), (Object[])new Object[]{biome.field_76791_y}));
        }
    }

    public BiomeGenBase[] getBiomes() {
        return BiomeGenBase.func_150565_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        super.func_150895_a(item, creativeTabs, list);
        if (BiomeExtractConfig.creativeTabVariants) {
            BiomeGenBase[] biomes = this.getBiomes();
            for (int i = 0; i < biomes.length; ++i) {
                if (biomes[i] == null) continue;
                list.add(this.createItemStack(biomes[i], 1));
            }
        }
    }

    public boolean isEmpty(ItemStack itemStack) {
        return this.getBiome(itemStack) == null;
    }

    public BiomeGenBase getBiome(ItemStack itemStack) {
        BiomeGenBase[] biomes;
        int biomeId;
        if (itemStack.func_77942_o() && (biomeId = itemStack.func_77978_p().func_74762_e(NBT_BIOMEID)) < (biomes = BiomeGenBase.func_150565_n()).length) {
            return biomes[biomeId];
        }
        return null;
    }

    public ItemStack createItemStack(BiomeGenBase biome, int amount) {
        ItemStack itemStack = new ItemStack((Item)BiomeExtract.getInstance(), amount, biome == null ? 0 : 1);
        if (biome != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(NBT_BIOMEID, biome.field_76756_M);
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        BiomeGenBase biome = this.getBiome(itemStack);
        if (biome == null) {
            return EnumRarity.COMMON;
        }
        return biome.func_76741_f() <= 0.05f ? EnumRarity.EPIC : (biome.func_76741_f() <= 0.1f ? EnumRarity.RARE : EnumRarity.UNCOMMON);
    }
}

