/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.BloodStainedBlock;
import org.cyclops.evilcraft.block.BloodStainedBlockConfig;
import org.cyclops.evilcraft.client.particle.EntityBloodSplashFX;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.fluid.Blood;

public class CreativeBloodDrop
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static CreativeBloodDrop _instance = null;
    private static final int MB_FILL_PERTICK = 1000;

    public static CreativeBloodDrop getInstance() {
        return _instance;
    }

    public CreativeBloodDrop(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, (Fluid)Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo((List)list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.autoSupply"));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        CreativeBloodDrop.updateAutoFill((ItemFluidContainer)this, itemStack, world, entity);
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public static void updateAutoFill(ItemFluidContainer item, ItemStack itemStack, World world, Entity entity) {
        IFluidContainerItem fluidContainer;
        FluidStack heldFluid;
        EntityPlayer player;
        ItemStack held;
        FluidStack tickFluid;
        if (entity instanceof EntityPlayer && !world.field_72995_K && ItemHelpers.isActivated(itemStack) && (tickFluid = item.getFluid(itemStack)) != null && tickFluid.amount > 0 && (held = (player = (EntityPlayer)entity).func_71045_bC()) != null && held != itemStack && held.func_77973_b() instanceof IFluidContainerItem && !player.func_71039_bw() && ((heldFluid = (fluidContainer = (IFluidContainerItem)held.func_77973_b()).getFluid(held)) == null || heldFluid.isFluidEqual(tickFluid) && heldFluid.amount < fluidContainer.getCapacity(held))) {
            int filled = fluidContainer.fill(held, new FluidStack(tickFluid.getFluid(), 1000), true);
            item.drain(itemStack, filled, true);
        }
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return new FluidStack(this.getFluid(), maxDrain);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        return resource.amount;
    }

    public FluidStack getFluid(ItemStack itemStack) {
        return new FluidStack(this.getFluid(), 500);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Item)this));
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (player.func_70093_af() && Configs.isEnabled(BloodStainedBlockConfig.class) && (BloodStainedBlock.getInstance().canSetInnerBlock(block, (IBlockAccess)world, blockPos) || block == BloodStainedBlock.getInstance())) {
            BloodStainedBlock.getInstance().stainBlock(world, blockPos, 1000);
            if (world.field_72995_K) {
                EntityBloodSplashFX.spawnParticles(world, blockPos.func_177982_a(0, 1, 0), 5, 1 + world.field_73012_v.nextInt(2));
            }
            return false;
        }
        return super.onItemUseFirst(itemStack, player, world, blockPos, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(itemStack, world, player);
        }
        MovingObjectPosition target = this.func_77621_a(world, player, false);
        if (!(target != null && target.field_72313_a != MovingObjectPosition.MovingObjectType.MISS || world.field_72995_K)) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return itemStack;
    }
}

