/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.modcompat.jei.bloodinfuser;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;

public class BloodInfuserRecipeJEI
extends BlankRecipeWrapper {
    private final FluidStack fluidStack;
    private final int upgrade;
    private final List<ItemStack> input;
    private final List<ItemStack> output;
    private final String xpString;

    public BloodInfuserRecipeJEI(IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        this.fluidStack = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getFluidStack();
        this.upgrade = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getTier();
        this.input = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getItemStacks();
        this.output = ((ItemStackRecipeComponent)recipe.getOutput()).getItemStacks();
        this.xpString = Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(((DurationXpRecipeProperties)recipe.getProperties()).getXp())});
    }

    public List getInputs() {
        return this.input;
    }

    public List getOutputs() {
        return this.output;
    }

    public List<FluidStack> getFluidInputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.fluidStack});
    }

    public static List<BloodInfuserRecipeJEI> getAllRecipes() {
        return Lists.transform((List)BloodInfuser.getInstance().getRecipeRegistry().allRecipes(), (Function)new Function<IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>, BloodInfuserRecipeJEI>(){

            @Nullable
            public BloodInfuserRecipeJEI apply(IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> input) {
                return new BloodInfuserRecipeJEI(input);
            }
        });
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight);
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        fontRendererObj.func_78276_b(this.xpString, 100 - fontRendererObj.func_78256_a(this.xpString) / 2, 5, Color.gray.getRGB());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BloodInfuserRecipeJEI)) {
            return false;
        }
        BloodInfuserRecipeJEI other = (BloodInfuserRecipeJEI)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FluidStack this$fluidStack = this.getFluidStack();
        FluidStack other$fluidStack = other.getFluidStack();
        if (this$fluidStack == null ? other$fluidStack != null : !this$fluidStack.equals(other$fluidStack)) {
            return false;
        }
        if (this.getUpgrade() != other.getUpgrade()) {
            return false;
        }
        List<ItemStack> this$input = this.getInput();
        List<ItemStack> other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        List<ItemStack> this$output = this.getOutput();
        List<ItemStack> other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        String this$xpString = this.getXpString();
        String other$xpString = other.getXpString();
        return !(this$xpString == null ? other$xpString != null : !this$xpString.equals(other$xpString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BloodInfuserRecipeJEI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FluidStack $fluidStack = this.getFluidStack();
        result = result * 59 + ($fluidStack == null ? 0 : $fluidStack.hashCode());
        result = result * 59 + this.getUpgrade();
        List<ItemStack> $input = this.getInput();
        result = result * 59 + ($input == null ? 0 : ((Object)$input).hashCode());
        List<ItemStack> $output = this.getOutput();
        result = result * 59 + ($output == null ? 0 : ((Object)$output).hashCode());
        String $xpString = this.getXpString();
        result = result * 59 + ($xpString == null ? 0 : $xpString.hashCode());
        return result;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public int getUpgrade() {
        return this.upgrade;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public String getXpString() {
        return this.xpString;
    }

    public String toString() {
        return "BloodInfuserRecipeJEI(fluidStack=" + this.getFluidStack() + ", upgrade=" + this.getUpgrade() + ", input=" + this.getInput() + ", output=" + this.getOutput() + ", xpString=" + this.getXpString() + ")";
    }
}

