/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.block.BloodChest;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.inventory.container.ContainerBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.RepairItemTickAction;

public class TileBloodChest
extends TickingTankInventoryTileEntity<TileBloodChest> {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 10;
    public static final int SLOTS = 11;
    public static final int SLOT_CONTAINER = 10;
    public static String TANKNAME = "bloodChestTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private Block block = BloodChest.getInstance();
    private static final Map<Class<?>, ITickAction<TileBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;

    public TileBloodChest() {
        super(11, BloodChest.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID, 1);
        for (int i = 0; i < 10; ++i) {
            this.addTicker(new TickComponent<TileBloodChest, ITickAction<TileBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<TileBloodChest, ITickAction<TileBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 10, false));
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(10);
        LinkedList<Integer> inSlotsInventory = new LinkedList<Integer>();
        for (int i = 0; i < 10; ++i) {
            inSlotsInventory.add(i);
        }
        inSlotsInventory.add(10);
        this.addSlotsToSide(EnumFacing.EAST, inSlotsTank);
        this.addSlotsToSide(EnumFacing.UP, inSlotsInventory);
        this.addSlotsToSide(EnumFacing.DOWN, inSlotsInventory);
        this.addSlotsToSide(EnumFacing.SOUTH, inSlotsInventory);
        this.addSlotsToSide(EnumFacing.WEST, inSlotsInventory);
    }

    public EnumFacing getRotation() {
        return (EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (IProperty)BloodChest.FACING, (Object)EnumFacing.NORTH);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, (CyclopsTileEntity)this, BloodFluidConverter.getInstance());
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 10) {
            return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (SingleUseTank)this.getTank());
        }
        if (slot <= 10 && slot >= 0) {
            return SlotRepairable.checkIsItemValid(itemStack);
        }
        return false;
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (BlockPos)this.func_174877_v())) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_178781_a((double)((float)x - range), (double)((float)y - range), (double)((float)z - range), (double)((float)(x + 1) + range), (double)((float)(y + 1) + range), (double)((float)(z + 1) + range)));
            for (EntityPlayer player : entities) {
                if (!(player.field_71070_bA instanceof ContainerBloodChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.1f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
        this.triggerPlayerUsageChange(1);
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
        this.triggerPlayerUsageChange(-1);
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return super.func_70300_a(entityPlayer) && (this.field_145850_b == null || this.field_145850_b.func_175625_s(this.func_174877_v()) != this);
    }

    @Override
    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new RepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
    }
}

