/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;
import org.cyclops.evilcraft.block.BoxOfEternalClosureConfig;
import org.cyclops.evilcraft.block.SpiritReanimator;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.tileentity.TileWorking;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.spiritreanimator.ReanimateTickAction;

public class TileSpiritReanimator
extends TileWorking<TileSpiritReanimator, MutableDouble> {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int SLOT_EGG = 2;
    public static final int SLOTS_OUTPUT = 3;
    public static final int SLOTS = 4;
    public static String TANKNAME = "spiritReanimatorTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private static final Map<Class<?>, ITickAction<TileSpiritReanimator>> REANIMATE_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileSpiritReanimator>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private int reanimateTicker = this.addTicker(new TickComponent<TileSpiritReanimator, ITickAction<TileSpiritReanimator>>(this, REANIMATE_COOK_TICK_ACTIONS, 1));
    @NBTPersist
    private Boolean caughtError = false;

    public TileSpiritReanimator() {
        super(4, SpiritReanimator.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileSpiritReanimator, ITickAction<TileSpiritReanimator>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        inSlots.add(2);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(3);
        this.addSlotsToSide(EnumFacing.EAST, inSlotsTank);
        this.addSlotsToSide(EnumFacing.UP, inSlots);
        this.addSlotsToSide(EnumFacing.DOWN, outSlots);
        this.addSlotsToSide(EnumFacing.SOUTH, outSlots);
        this.addSlotsToSide(EnumFacing.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileSpiritReanimator, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(TileSpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSpiritReanimator, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(TileSpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    public EnumFacing getRotation() {
        return (EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (IProperty)SpiritReanimator.FACING, (Object)EnumFacing.NORTH);
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, (CyclopsTileEntity)this, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.reanimateTicker;
    }

    public String getEntityName() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritReanimator.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getSpiritName(boxStack);
        }
        return null;
    }

    public int getEntityID() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritReanimator.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getSpiritID(boxStack);
        }
        return -1;
    }

    public static Item getAllowedCookItem() {
        Item allowedItem = Items.field_151034_e;
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            allowedItem = Item.func_150898_a((Block)BoxOfEternalClosure.getInstance());
        }
        return allowedItem;
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        return itemStack != null && TileSpiritReanimator.getAllowedCookItem() == itemStack.func_77973_b();
    }

    public int getConsumeSlot() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 2) {
            return itemStack.func_77973_b() == Items.field_151110_aK;
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (SingleUseTank)this.getTank());
        }
        return super.func_94041_b(slot, itemStack);
    }

    @Override
    public boolean canWork() {
        ItemStack eggStack = this.func_70301_a(2);
        ItemStack outputStack = this.func_70301_a(3);
        boolean validIdStack = this.getEntityID() != -1 && EntityList.field_75627_a.get(this.getEntityID()) != null && (outputStack == null || outputStack.func_77976_d() > outputStack.field_77994_a && outputStack.func_77952_i() == this.getEntityID());
        boolean validNameStack = this.getEntityName() != null && EntityRegistry.getEggs().containsKey(this.getEntityName()) && (outputStack == null || outputStack.func_77976_d() > outputStack.field_77994_a && this.getEntityName().equals(ItemMonsterPlacer.getEntityName((ItemStack)outputStack)));
        return eggStack != null && (validIdStack || validNameStack);
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)SpiritReanimator.ON, (Comparable)Boolean.valueOf(this.isWorking())));
    }

    static {
        REANIMATE_COOK_TICK_ACTIONS.put(BoxOfEternalClosure.class, new ReanimateTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }
}

