/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.purifier;

import java.util.HashMap;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.tileentity.TilePurifier;

public class DisenchantPurifyAction
implements IPurifierAction {
    public static final Wrapper<Item> ALLOWED_BOOK = new Wrapper();
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() == ALLOWED_BOOK.get();
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        if (tile.getBucketsFloored() == tile.getMaxBuckets() && tile.getPurifyItem() != null && tile.getAdditionalItem() != null && tile.getAdditionalItem().func_77973_b() == ALLOWED_BOOK.get()) {
            NBTTagList enchantmentList = tile.getPurifyItem().func_77986_q();
            return enchantmentList != null && enchantmentList.func_74745_c() > 0;
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem();
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        NBTTagList enchantmentList = purifyItem.func_77986_q();
        if (enchantmentList != null && enchantmentList.func_74745_c() > 0) {
            if (tick >= 60) {
                if (!world.field_72995_K) {
                    int enchantmentListID = world.field_73012_v.nextInt(enchantmentList.func_74745_c());
                    int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID);
                    int id = EnchantmentHelpers.getEnchantmentID((ItemStack)purifyItem, (int)enchantmentListID);
                    ItemStack enchantedItem = new ItemStack((Item)Items.field_151134_bR, 1);
                    HashMap<Integer, Integer> enchantments = new HashMap<Integer, Integer>();
                    enchantments.put(id, level);
                    EnchantmentHelper.func_82782_a(enchantments, (ItemStack)enchantedItem);
                    EnchantmentHelpers.setEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID, (int)0);
                    tile.setAdditionalItem(enchantedItem);
                }
                tile.setBuckets(0, tile.getBucketsRest());
                done = true;
            }
            if (world.field_72995_K) {
                tile.showEffect();
                tile.showEnchantingEffect();
            }
        }
        return done;
    }
}

