/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.purifier;

import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.ConfigurableEnchantment;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.tileentity.TilePurifier;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;

public class ToolBadEnchantPurifyAction
implements IPurifierAction {
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        Iterator i$;
        if (tile.getPurifyItem() != null && tile.getBucketsFloored() > 0 && (i$ = DamageableItemRepairAction.BAD_ENCHANTS.iterator()).hasNext()) {
            ConfigurableEnchantment enchant = (ConfigurableEnchantment)i$.next();
            int enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)tile.getPurifyItem(), (int)enchant.field_77352_x);
            return enchantmentListID >= 0;
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem();
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        for (ConfigurableEnchantment enchant : DamageableItemRepairAction.BAD_ENCHANTS) {
            int enchantmentListID;
            if (done || (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)purifyItem, (int)enchant.field_77352_x)) <= -1) continue;
            if (tick >= 60) {
                if (!world.field_72995_K) {
                    int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID);
                    EnchantmentHelpers.setEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID, (int)(level - 1));
                }
                tile.setBuckets(tile.getBucketsFloored() - 1, tile.getBucketsRest());
                done = true;
            }
            if (!world.field_72995_K) continue;
            tile.showEffect();
        }
        return done;
    }
}

