/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.spiritreanimator;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.block.SpiritReanimatorConfig;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileSpiritFurnace;
import org.cyclops.evilcraft.tileentity.TileSpiritReanimator;

public class ReanimateTickAction
implements ITickAction<TileSpiritReanimator> {
    @Override
    public boolean canTick(TileSpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        return tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, tick) && tile.canWork();
    }

    protected ItemStack getCookStack(TileSpiritFurnace tile) {
        return tile.getInventory().func_70301_a(tile.getConsumeSlot());
    }

    protected ItemStack getSpawnEgg(int entityId) {
        return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("spawn_egg")), 1, entityId);
    }

    protected ItemStack getSpawnEgg(String entityName) {
        ItemStack itemStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("spawn_egg")));
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("entity_name", entityName);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    @Override
    public void onTick(TileSpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), true);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            int entityID = tile.getEntityID();
            ItemStack spawnEgg = null;
            if (entityID < 0) {
                String entityName = tile.getEntityName();
                if (entityName != null) {
                    spawnEgg = this.getSpawnEgg(entityName);
                }
            } else {
                spawnEgg = this.getSpawnEgg(entityID);
            }
            if (spawnEgg != null && this.addToProduceSlot(tile, spawnEgg)) {
                tile.getInventory().func_70298_a(2, 1);
            }
            if (SpiritReanimatorConfig.clearBoxContents) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
        }
    }

    protected int getRequiredMb(TileSpiritReanimator tile, int tick) {
        MutableDouble drain = new MutableDouble((double)SpiritReanimatorConfig.mBPerTick);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritReanimator.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public float getRequiredTicks(TileSpiritReanimator tile, int slot, int tick) {
        MutableDouble drain = new MutableDouble((double)SpiritReanimatorConfig.requiredTicks);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritReanimator.UPGRADEEVENT_SPEED));
        return (int)drain.getValue().doubleValue();
    }

    public boolean addToProduceSlot(TileSpiritReanimator tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot((IInventory)tile.getInventory(), (int)3, (ItemStack)itemStack);
    }
}

