/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.shell;

import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellStateComponent;
import dev.kir.sync.entity.ShellEntity;
import dev.kir.sync.item.SimpleInventory;
import dev.kir.sync.util.WorldUtil;
import dev.kir.sync.util.nbt.NbtSerializer;
import dev.kir.sync.util.nbt.NbtSerializerFactory;
import dev.kir.sync.util.nbt.NbtSerializerFactoryBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class ShellState {
    public static final float PROGRESS_START = 0.0f;
    public static final float PROGRESS_DONE = 1.0f;
    public static final float PROGRESS_PRINTING = 0.75f;
    public static final float PROGRESS_PAINTING = 0.25f;
    private static final NbtSerializerFactory<ShellState> NBT_SERIALIZER_FACTORY = new NbtSerializerFactoryBuilder<ShellState>().add(UUID.class, "uuid", x -> x.uuid, (x, uuid) -> {
        x.uuid = uuid;
    }).add(Integer.class, "color", x -> x.color == null ? -1 : x.color.method_7789(), (x, color) -> {
        x.color = color == -1 ? null : class_1767.method_7791((int)color);
    }).add(Float.class, "progress", x -> Float.valueOf(x.progress), (x, progress) -> {
        x.progress = progress.floatValue();
    }).add(Boolean.class, "isArtificial", x -> x.isArtificial, (x, isArtificial) -> {
        x.isArtificial = isArtificial;
    }).add(UUID.class, "ownerUuid", x -> x.ownerUuid, (x, ownerUuid) -> {
        x.ownerUuid = ownerUuid;
    }).add(String.class, "ownerName", x -> x.ownerName, (x, ownerName) -> {
        x.ownerName = ownerName;
    }).add(Float.class, "health", x -> Float.valueOf(x.health), (x, health) -> {
        x.health = health.floatValue();
    }).add(Integer.class, "gameMode", x -> x.gameMode, (x, gameMode) -> {
        x.gameMode = gameMode;
    }).add(class_2499.class, "inventory", x -> x.inventory.writeNbt(new class_2499()), (x, inventory) -> {
        x.inventory = new SimpleInventory();
        x.inventory.readNbt((class_2499)inventory);
    }).add(class_2487.class, "components", x -> x.component.writeNbt(new class_2487()), (x, component) -> {
        x.component = ShellStateComponent.empty();
        if (component != null) {
            x.component.readNbt((class_2487)component);
        }
    }).add(Integer.class, "foodLevel", x -> x.foodLevel, (x, foodLevel) -> {
        x.foodLevel = foodLevel;
    }).add(Float.class, "saturationLevel", x -> Float.valueOf(x.saturationLevel), (x, saturationLevel) -> {
        x.saturationLevel = saturationLevel.floatValue();
    }).add(Float.class, "exhaustion", x -> Float.valueOf(x.exhaustion), (x, exhaustion) -> {
        x.exhaustion = exhaustion.floatValue();
    }).add(Integer.class, "experienceLevel", x -> x.experienceLevel, (x, experienceLevel) -> {
        x.experienceLevel = experienceLevel;
    }).add(Float.class, "experienceProgress", x -> Float.valueOf(x.experienceProgress), (x, experienceProgress) -> {
        x.experienceProgress = experienceProgress.floatValue();
    }).add(Integer.class, "totalExperience", x -> x.totalExperience, (x, totalExperience) -> {
        x.totalExperience = totalExperience;
    }).add(class_2960.class, "world", x -> x.world, (x, world) -> {
        x.world = world;
    }).add(class_2338.class, "pos", x -> x.pos, (x, pos) -> {
        x.pos = pos;
    }).build();
    private UUID uuid;
    private float progress;
    private class_1767 color;
    private boolean isArtificial;
    private UUID ownerUuid;
    private String ownerName;
    private float health;
    private int gameMode;
    private SimpleInventory inventory;
    private ShellStateComponent component;
    private int foodLevel;
    private float saturationLevel;
    private float exhaustion;
    private int experienceLevel;
    private float experienceProgress;
    private int totalExperience;
    private class_2960 world;
    private class_2338 pos;
    private final NbtSerializer<ShellState> serializer = NBT_SERIALIZER_FACTORY.create(this);
    @Environment(value=EnvType.CLIENT)
    private ShellEntity entityInstance = null;

    public UUID getUuid() {
        return this.uuid;
    }

    public class_1767 getColor() {
        return this.color;
    }

    public void setColor(class_1767 color) {
        this.color = color;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
    }

    public boolean isArtificial() {
        return this.isArtificial;
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public float getHealth() {
        return this.health;
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public ShellStateComponent getComponent() {
        return this.component;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public float getExperienceProgress() {
        return this.experienceProgress;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public class_2960 getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    private ShellState() {
    }

    public static ShellState empty(class_3222 player, class_2338 pos) {
        return ShellState.empty(player, pos, null);
    }

    public static ShellState empty(class_3222 player, class_2338 pos, class_1767 color) {
        return ShellState.create(player, pos, color, 0.0f, true, false);
    }

    public static ShellState of(class_3222 player, class_2338 pos) {
        return ShellState.of(player, pos, null);
    }

    public static ShellState of(class_3222 player, class_2338 pos, class_1767 color) {
        return ShellState.create(player, pos, color, 1.0f, ((Shell)player).isArtificial(), true);
    }

    public static ShellState fromNbt(class_2487 nbt) {
        ShellState state = new ShellState();
        state.readNbt(nbt);
        return state;
    }

    private static ShellState create(class_3222 player, class_2338 pos, class_1767 color, float progress, boolean isArtificial, boolean copyPlayerState) {
        ShellState shell = new ShellState();
        shell.uuid = UUID.randomUUID();
        shell.progress = progress;
        shell.color = color;
        shell.isArtificial = isArtificial;
        shell.ownerUuid = player.method_5667();
        shell.ownerName = player.method_5477().method_10851();
        shell.gameMode = player.field_13974.method_14257().method_8379();
        shell.inventory = new SimpleInventory();
        shell.component = ShellStateComponent.empty();
        if (copyPlayerState) {
            shell.health = player.method_6032();
            shell.inventory.clone((class_1263)player.method_31548());
            shell.component.clone(ShellStateComponent.of(player));
            shell.foodLevel = player.method_7344().method_7586();
            shell.saturationLevel = player.method_7344().method_7589();
            shell.exhaustion = player.method_7344().method_35219();
            shell.experienceLevel = player.field_7520;
            shell.experienceProgress = player.field_7510;
            shell.totalExperience = player.field_7495;
        } else {
            shell.health = player.method_6063();
            shell.foodLevel = 20;
            shell.saturationLevel = 5.0f;
        }
        shell.world = WorldUtil.getId(player.field_6002);
        shell.pos = pos;
        return shell;
    }

    public void dropInventory(class_3218 world) {
        this.dropInventory(world, this.pos);
    }

    public void dropInventory(class_3218 world, class_2338 pos) {
        Stream.of(this.inventory.main, this.inventory.armor, this.inventory.offHand, this.component.getItems()).flatMap(Collection::stream).forEach(x -> this.dropItemStack((class_1937)world, pos, (class_1799)x));
    }

    public void dropXp(class_3218 world) {
        this.dropXp(world, this.pos);
    }

    public void dropXp(class_3218 world, class_2338 pos) {
        int xp = Math.min(this.experienceLevel * 7, 100) + this.component.getXp();
        class_243 vecPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        class_1303.method_31493((class_3218)world, (class_243)vecPos, (int)xp);
    }

    public void drop(class_3218 world) {
        this.drop(world, this.pos);
    }

    public void drop(class_3218 world, class_2338 pos) {
        this.dropInventory(world, pos);
        this.dropXp(world, pos);
    }

    private void dropItemStack(class_1937 world, class_2338 pos, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        class_1542 item = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
        item.method_6982(40);
        item.method_6981(this.getOwnerUuid());
        float h = world.field_9229.nextFloat() * 0.5f;
        float v = world.field_9229.nextFloat() * 2.0f * (float)Math.PI;
        item.method_18800((double)(-class_3532.method_15374((float)v) * h), 0.2, (double)(class_3532.method_15362((float)v) * h));
        world.method_8649((class_1297)item);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        return this.serializer.writeNbt(nbt);
    }

    public void readNbt(class_2487 nbt) {
        this.serializer.readNbt(nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        Object object = o;
        if (!(object instanceof ShellState)) return false;
        ShellState state = (ShellState)object;
        if (!Objects.equals(this.uuid, state.uuid)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    @Environment(value=EnvType.CLIENT)
    public ShellEntity asEntity() {
        if (this.entityInstance == null) {
            this.entityInstance = new ShellEntity(this);
        }
        return this.entityInstance;
    }
}

