/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.ShellConstructorBlock;
import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.entity.damage.FingerstickDamageSource;
import dev.kir.sync.util.BlockPosUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ShellConstructorBlockEntity
extends AbstractShellContainerBlockEntity
implements EnergyStorage {
    public ShellConstructorBlockEntity(class_2338 pos, class_2680 state) {
        super(SyncBlockEntities.SHELL_CONSTRUCTOR, pos, state);
    }

    @Override
    public void onServerTick(class_1937 world, class_2338 pos, class_2680 state) {
        super.onServerTick(world, pos, state);
        if (ShellConstructorBlock.isOpen(state)) {
            ShellConstructorBlock.setOpen(state, world, pos, BlockPosUtil.hasPlayerInside(pos, (class_1924)world));
        }
    }

    @Override
    public class_1269 onUse(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        PlayerSyncEvents.ShellConstructionFailureReason failureReason = this.beginShellConstruction(player);
        if (failureReason == null) {
            return class_1269.field_5812;
        }
        player.method_7353(failureReason.toText(), true);
        return class_1269.field_21466;
    }

    @Nullable
    private PlayerSyncEvents.ShellConstructionFailureReason beginShellConstruction(class_1657 player) {
        PlayerSyncEvents.ShellConstructionFailureReason failureReason;
        PlayerSyncEvents.ShellConstructionFailureReason shellConstructionFailureReason = failureReason = this.shell == null ? ((PlayerSyncEvents.AllowShellConstruction)PlayerSyncEvents.ALLOW_SHELL_CONSTRUCTION.invoker()).allowShellConstruction(player, this) : PlayerSyncEvents.ShellConstructionFailureReason.OCCUPIED;
        if (failureReason != null) {
            return failureReason;
        }
        class_1657 class_16572 = player;
        if (class_16572 instanceof class_3222) {
            boolean hasTotemOfUndying;
            class_3222 serverPlayer = (class_3222)class_16572;
            SyncConfig config = Sync.getConfig();
            float damage = serverPlayer.field_13995.method_3754() ? config.hardcoreFingerstickDamage : config.fingerstickDamage;
            boolean isCreative = !serverPlayer.field_13974.method_14257().method_8388();
            boolean isLowOnHealth = player.method_6032() + player.method_6067() <= damage;
            boolean bl = hasTotemOfUndying = player.method_6047().method_31574(class_1802.field_8288) || player.method_6079().method_31574(class_1802.field_8288);
            if (isLowOnHealth && !isCreative && !hasTotemOfUndying && config.warnPlayerInsteadOfKilling) {
                return PlayerSyncEvents.ShellConstructionFailureReason.NOT_ENOUGH_HEALTH;
            }
            player.method_5643(FingerstickDamageSource.getInstance(), damage);
            this.shell = ShellState.empty(serverPlayer, this.field_11867);
            if (isCreative && config.enableInstantShellConstruction) {
                this.shell.setProgress(1.0f);
            }
        }
        return null;
    }

    public long getAmount() {
        return 0L;
    }

    public long getCapacity() {
        return 0L;
    }

    public boolean supportsInsertion() {
        return true;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long insert(long amount, TransactionContext context) {
        ShellConstructorBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null || bottom.shell.getProgress() >= 1.0f) {
            return 0L;
        }
        long requiredEnergyAmount = Sync.getConfig().shellConstructorCapacity;
        long maxEnergy = (long)((1.0f - bottom.shell.getProgress()) * (float)requiredEnergyAmount);
        context.addCloseCallback((ctx, result) -> {
            if (result.wasCommitted()) {
                bottom.shell.setProgress(bottom.shell.getProgress() + (float)amount / (float)requiredEnergyAmount);
            }
        });
        return class_3532.method_24156((long)amount, (long)0L, (long)maxEnergy);
    }

    public long extract(long maxAmount, TransactionContext context) {
        return 0L;
    }

    static {
        ShellStateContainer.LOOKUP.registerForBlockEntity((x, s) -> x.method_11002() && AbstractShellContainerBlock.isBottom(x.method_11010()) && (s == null || s.equals(x.getShellState())) ? x : null, SyncBlockEntities.SHELL_CONSTRUCTOR);
        EnergyStorage.SIDED.registerForBlockEntities((x, __) -> (EnergyStorage)x, new class_2591[]{SyncBlockEntities.SHELL_CONSTRUCTOR});
    }
}

