/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.model;

import dev.kir.sync.client.model.VoxelProvider;
import dev.kir.sync.client.render.CustomRenderLayer;
import dev.kir.sync.util.client.render.ModelUtil;
import dev.kir.sync.util.math.Voxel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class VoxelModel
extends class_3879 {
    public float completeness = 0.0f;
    public float destructionProgress;
    public final float sizeX;
    public final float sizeY;
    public final float sizeZ;
    public final float pivotX;
    public final float pivotY;
    public final float pivotZ;
    private final List<Voxel> voxels;
    private final class_630 voxel;
    private final long seed;
    private final Random random;

    private VoxelModel(Stream<Voxel> voxels, boolean isUpsideDown, long seed) {
        super(id -> CustomRenderLayer.getVoxels());
        this.voxels = voxels.collect(Collectors.toList());
        this.voxel = new class_630(List.of(new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, true, 1.0f, 1.0f)), Map.of());
        class_3545<class_1160, class_1160> pivotAndSize = VoxelModel.computePivotAndSize(isUpsideDown, this.voxels);
        class_1160 pivot = (class_1160)pivotAndSize.method_15442();
        class_1160 size = (class_1160)pivotAndSize.method_15441();
        this.pivotX = pivot.method_4943();
        this.pivotY = pivot.method_4945();
        this.pivotZ = pivot.method_4947();
        this.sizeX = size.method_4943();
        this.sizeY = size.method_4945();
        this.sizeZ = size.method_4947();
        this.seed = seed;
        this.random = new Random();
    }

    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.destructionProgress > 0.0f) {
            this.renderWithDestruction(matrices, vertices, light, overlay, red, green, blue, alpha);
        } else {
            this.renderWithoutDestruction(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    private void renderWithoutDestruction(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        class_630 voxel = this.voxel;
        List<Voxel> voxels = this.voxels;
        int size = class_3532.method_15340((int)((int)((float)voxels.size() * this.completeness)), (int)0, (int)voxels.size());
        for (int i = 0; i < size; ++i) {
            Voxel v = voxels.get(i);
            voxel.method_2851(v.x, v.y, v.z);
            voxel.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    private void renderWithDestruction(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        Random rand = this.random;
        class_630 voxel = this.voxel;
        List<Voxel> voxels = this.voxels;
        int size = class_3532.method_15340((int)((int)((float)voxels.size() * this.completeness)), (int)0, (int)voxels.size());
        float minY = this.pivotY;
        float maxY = this.pivotY + this.sizeY;
        if (minY > maxY) {
            float tmp = minY;
            minY = maxY;
            maxY = tmp;
        }
        float g = -this.sizeY * 0.005f;
        float t = this.destructionProgress * 20.0f;
        float k = t * t / 2.0f;
        rand.setSeed(this.seed);
        for (int i = 0; i < size; ++i) {
            float vX = rand.nextFloat() - 0.5f;
            float vY = g * (rand.nextFloat() - 0.5f);
            float vZ = rand.nextFloat() - 0.5f;
            Voxel v = voxels.get(i);
            float x = v.x + vX * t;
            float y = class_3532.method_15363((float)(v.y + vY * t + g * k), (float)minY, (float)maxY);
            float z = v.z + vZ * t;
            voxel.method_2851(x, y, z);
            voxel.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    public static VoxelModel fromModel(class_4592<?> model, Random random) {
        VoxelProvider voxelProvider;
        Stream<Voxel> stream;
        class_4592<?> class_45922 = model;
        if (class_45922 instanceof VoxelProvider) {
            VoxelProvider voxelProvider2 = (VoxelProvider)class_45922;
            stream = voxelProvider2.getVoxels();
        } else {
            stream = VoxelModel.extractVoxels(model);
        }
        Stream<Voxel> voxels = stream;
        class_4592<?> class_45923 = model;
        boolean isUpsideDown = !(class_45923 instanceof VoxelProvider) || (voxelProvider = (VoxelProvider)class_45923).isUpsideDown();
        HashMap voxelMap = new HashMap();
        voxels.forEach(x -> {
            if (!voxelMap.containsKey(Float.valueOf(x.y))) {
                voxelMap.put(Float.valueOf(x.y), new ArrayList());
            }
            ((List)voxelMap.get(Float.valueOf(x.y))).add(x);
        });
        for (List voxelsAtY : voxelMap.values()) {
            for (int i = voxelsAtY.size() - 1; i > 0; --i) {
                int j = random.nextInt(i + 1);
                Voxel tmp = (Voxel)voxelsAtY.get(j);
                voxelsAtY.set(j, (Voxel)voxelsAtY.get(i));
                voxelsAtY.set(i, tmp);
            }
        }
        int sign = isUpsideDown ? -1 : 1;
        Stream<Voxel> orderedVoxels = voxelMap.entrySet().stream().sorted((a, b) -> sign * (int)Math.signum(((Float)a.getKey()).floatValue() - ((Float)b.getKey()).floatValue())).flatMap(x -> ((List)x.getValue()).stream());
        return new VoxelModel(orderedVoxels, isUpsideDown, random.nextLong());
    }

    private static Stream<Voxel> extractVoxels(class_4592<?> model) {
        return Stream.concat(StreamSupport.stream(model.method_22946().spliterator(), false), StreamSupport.stream(model.method_22948().spliterator(), false)).flatMap(ModelUtil::asVoxels);
    }

    private static class_3545<class_1160, class_1160> computePivotAndSize(boolean isUpsideDown, List<Voxel> voxels) {
        if (voxels.size() == 0) {
            return new class_3545((Object)class_1160.field_29501, (Object)class_1160.field_29501);
        }
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Voxel voxel : voxels) {
            if (voxel.x > maxX) {
                maxX = voxel.x;
            }
            if (voxel.x < minX) {
                minX = voxel.x;
            }
            if (voxel.y > maxY) {
                maxY = voxel.y;
            }
            if (voxel.y < minY) {
                minY = voxel.y;
            }
            if (voxel.z > maxZ) {
                maxZ = voxel.z;
            }
            if (!(voxel.z < minZ)) continue;
            minZ = voxel.z;
        }
        int signX = isUpsideDown ? -1 : 1;
        int signY = isUpsideDown ? -1 : 1;
        class_1160 pivot = new class_1160(signX == 1 ? minX : maxX, signY == 1 ? minY : maxY, minZ);
        class_1160 size = new class_1160((float)signX * (maxX - minX + 1.0f), (float)signY * (maxY - minY + 1.0f), maxZ - minZ + 1.0f);
        return new class_3545((Object)pivot, (Object)size);
    }
}

