/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import dev.kir.sync.api.shell.ShellState;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2703;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class ShellEntity
extends class_742 {
    private static final Cache<UUID, class_640> PLAYER_ENTRY_CACHE = CacheBuilder.newBuilder().initialCapacity(20).maximumSize(40L).expireAfterAccess(20L, TimeUnit.MINUTES).build();
    public boolean isActive = false;
    public float pitchProgress = 0.0f;
    private final ShellState state;
    private Runnable onInitialized;
    private final class_640 playerEntry;

    public ShellEntity(ShellState state) {
        this(class_310.method_1551().field_1687, state);
    }

    public ShellEntity(class_638 world, ShellState state) {
        super(world, ShellEntity.getPlayerEntry(state).method_2966());
        this.state = state;
        state.getInventory().copyTo((class_1263)this.method_31548());
        this.playerEntry = ShellEntity.getPlayerEntry(state);
        this.method_5725(state.getPos(), 0.0f, 0.0f);
        if (this.onInitialized != null) {
            this.onInitialized.run();
            this.onInitialized = null;
        }
    }

    public void onInitialized(Runnable runnable) {
        if (this.state == null) {
            this.onInitialized = runnable;
        } else if (runnable != null) {
            runnable.run();
        }
    }

    public ShellState getState() {
        return this.state;
    }

    protected void method_16078() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.state.dropInventory(serverWorld, this.method_24515());
        }
    }

    protected void method_23883() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.state.dropXp(serverWorld, this.method_24515());
        }
    }

    public boolean method_7337() {
        return true;
    }

    public boolean method_7325() {
        return false;
    }

    public boolean method_5733() {
        return false;
    }

    public boolean method_7348(class_1664 modelPart) {
        return true;
    }

    protected class_640 method_3123() {
        return this.playerEntry;
    }

    private static class_640 getPlayerEntry(ShellState state) {
        class_640 entry = (class_640)PLAYER_ENTRY_CACHE.getIfPresent((Object)state.getOwnerUuid());
        if (entry == null) {
            class_634 networkHandler = class_310.method_1551().method_1562();
            if (networkHandler != null && (entry = networkHandler.method_2871(state.getOwnerUuid())) == null) {
                entry = networkHandler.method_2874(state.getOwnerName());
            }
            if (entry == null) {
                entry = new class_640(new class_2703.class_2705(new GameProfile(state.getOwnerUuid(), state.getOwnerName()), 0, null, null));
            }
            PLAYER_ENTRY_CACHE.put((Object)state.getOwnerUuid(), (Object)entry);
        }
        return entry;
    }
}

