/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import com.mojang.authlib.GameProfile;
import dev.kir.sync.Sync;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.networking.SynchronizationRequestPacket;
import dev.kir.sync.api.shell.ClientShell;
import dev.kir.sync.api.shell.ShellPriority;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.client.gui.controller.DeathScreenController;
import dev.kir.sync.client.gui.controller.HudController;
import dev.kir.sync.entity.PersistentCameraEntity;
import dev.kir.sync.entity.PersistentCameraEntityGoal;
import dev.kir.sync.util.BlockPosUtil;
import dev.kir.sync.util.WorldUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_418;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
extends class_742
implements ClientShell {
    @Final
    @Shadow
    protected class_310 field_3937;
    @Unique
    private boolean isArtificial = false;
    @Unique
    private ConcurrentMap<UUID, ShellState> shellsById = new ConcurrentHashMap<UUID, ShellState>();

    private ClientPlayerEntityMixin(class_638 world, GameProfile profile) {
        super(world, profile);
    }

    @Override
    @Nullable
    public PlayerSyncEvents.SyncFailureReason beginSync(ShellState state) {
        PlayerSyncEvents.SyncFailureReason failureReason;
        class_638 world = this.field_17892;
        if (world == null) {
            return PlayerSyncEvents.SyncFailureReason.OTHER_PROBLEM;
        }
        PlayerSyncEvents.SyncFailureReason syncFailureReason = failureReason = this.canBeApplied(state) && state.getProgress() >= 1.0f ? ((PlayerSyncEvents.AllowSyncing)PlayerSyncEvents.ALLOW_SYNCING.invoker()).allowSync((class_1657)this, state) : PlayerSyncEvents.SyncFailureReason.INVALID_SHELL;
        if (failureReason != null) {
            return failureReason;
        }
        ((PlayerSyncEvents.StartSyncing)PlayerSyncEvents.START_SYNCING.invoker()).onStartSyncing((class_1657)this, state);
        class_2338 pos = this.method_24515();
        class_2350 facing = BlockPosUtil.getHorizontalFacing(pos, (class_1922)world).orElse(this.method_5735().method_10153());
        SynchronizationRequestPacket request = new SynchronizationRequestPacket(state);
        PersistentCameraEntityGoal cameraGoal = this.method_29504() ? PersistentCameraEntityGoal.limbo(pos, facing, state.getPos(), __ -> request.send()) : PersistentCameraEntityGoal.stairwayToHeaven(pos, facing, state.getPos(), __ -> request.send());
        HudController.hide();
        if (this.method_29504()) {
            DeathScreenController.suspend();
        }
        this.field_3937.method_1507(null);
        PersistentCameraEntity.setup(this.field_3937, cameraGoal);
        return null;
    }

    @Override
    public void endSync(class_2960 startWorld, class_2338 startPos, class_2350 startFacing, class_2960 targetWorld, class_2338 targetPos, class_2350 targetFacing, @Nullable ShellState storedState) {
        class_746 player = (class_746)this;
        boolean syncFailed = Objects.equals(startPos, targetPos);
        if (!syncFailed) {
            if (this.method_6032() <= 0.0f) {
                this.method_6033(0.01f);
            }
            this.field_6213 = 0;
        }
        float yaw = targetFacing.method_10153().method_10144();
        this.method_36456(yaw);
        this.field_5982 = yaw;
        this.field_6220 = this.field_6283 = yaw;
        this.field_6259 = this.field_6241 = yaw;
        player.field_3931 = player.field_3932 = yaw;
        this.method_36457(0.0f);
        this.field_6004 = 0.0f;
        player.field_3916 = 0.0f;
        player.field_3914 = 0.0f;
        Runnable restore = () -> {
            PersistentCameraEntity.unset(this.field_3937);
            HudController.restore();
            DeathScreenController.restore();
            if (!syncFailed) {
                ((PlayerSyncEvents.StopSyncing)PlayerSyncEvents.STOP_SYNCING.invoker()).onStopSyncing((class_1657)this, startPos, storedState);
            }
        };
        boolean enableCamera = Objects.equals(startWorld, targetWorld);
        if (enableCamera) {
            PersistentCameraEntityGoal cameraGoal = PersistentCameraEntityGoal.highwayToHell(startPos, startFacing, targetPos, targetFacing, __ -> restore.run());
            PersistentCameraEntity.setup(this.field_3937, cameraGoal);
        } else {
            restore.run();
        }
    }

    @Override
    public UUID getShellOwnerUuid() {
        return this.method_7334().getId();
    }

    @Override
    public boolean isArtificial() {
        return this.isArtificial;
    }

    @Override
    public void changeArtificialStatus(boolean isArtificial) {
        this.isArtificial = isArtificial;
    }

    @Override
    public void setAvailableShellStates(Stream<ShellState> states) {
        this.shellsById = states.collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
    }

    @Override
    public Stream<ShellState> getAvailableShellStates() {
        return this.shellsById.values().stream();
    }

    @Override
    public ShellState getShellStateByUuid(UUID uuid) {
        return uuid == null ? null : (ShellState)this.shellsById.get(uuid);
    }

    @Override
    public void add(ShellState state) {
        if (this.canBeApplied(state)) {
            this.shellsById.put(state.getUuid(), state);
        }
    }

    @Override
    public void remove(ShellState state) {
        if (state != null) {
            this.shellsById.remove(state.getUuid());
        }
    }

    @Override
    public void update(ShellState state) {
        if (this.canBeApplied(state) || state != null && this.shellsById.containsKey(state.getUuid())) {
            this.shellsById.put(state.getUuid(), state);
        }
    }

    public void method_5872(double cursorDeltaX, double cursorDeltaY) {
        if (this.field_3937.method_1560() == this) {
            super.method_5872(cursorDeltaX, cursorDeltaY);
        }
    }

    public void method_6033(float health) {
        super.method_6033(health);
        if (health <= 0.0f) {
            this.onDeath();
        }
    }

    @Unique
    private void onDeath() {
        ShellState respawnShell;
        boolean canRespawn = this.isArtificial() && this.shellsById.size() != 0;
        class_2338 pos = this.method_24515();
        class_2960 world = WorldUtil.getId(this.field_6002);
        Comparator<ShellState> comparator = ShellPriority.asComparator(world, pos, Sync.getConfig().syncPriority.stream().map(x -> x.priority));
        ShellState shellState = respawnShell = canRespawn ? (ShellState)this.shellsById.values().stream().filter(x -> this.canBeApplied((ShellState)x) && x.getProgress() >= 1.0f).min(comparator).orElse(null) : null;
        if (respawnShell != null) {
            this.beginSync(respawnShell);
        }
    }

    @Inject(method={"updatePostDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void updatePostDeath(CallbackInfo ci) {
        if (this.field_3937.field_1755 instanceof class_418) {
            this.field_6213 = class_3532.method_15340((int)this.field_6213, (int)0, (int)19);
        } else {
            this.field_6213 = class_3532.method_15340((int)(++this.field_6213), (int)0, (int)20);
            ci.cancel();
        }
    }
}

