/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.networking.PlayerIsAlivePacket;
import dev.kir.sync.api.networking.ShellStateUpdatePacket;
import dev.kir.sync.api.networking.ShellUpdatePacket;
import dev.kir.sync.api.shell.ServerShell;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateComponent;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import dev.kir.sync.util.BlockPosUtil;
import dev.kir.sync.util.WorldUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2696;
import net.minecraft.class_270;
import net.minecraft.class_2724;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4543;
import net.minecraft.class_5217;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements ServerShell {
    @Shadow
    private int field_13978;
    @Shadow
    private float field_13997;
    @Shadow
    private int field_13979;
    @Final
    @Shadow
    public MinecraftServer field_13995;
    @Unique
    private boolean isArtificial = false;
    @Unique
    private boolean shellDirty = false;
    @Unique
    private boolean undead = false;
    @Unique
    private ConcurrentMap<UUID, ShellState> shellsById = new ConcurrentHashMap<UUID, ShellState>();
    @Unique
    private Map<UUID, class_3545<ShellStateUpdateType, ShellState>> shellStateChanges = new ConcurrentHashMap<UUID, class_3545<ShellStateUpdateType, ShellState>>();

    private ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Override
    public UUID getShellOwnerUuid() {
        return this.method_7334().getId();
    }

    @Override
    public boolean isArtificial() {
        return this.isArtificial;
    }

    @Override
    public void changeArtificialStatus(boolean isArtificial) {
        if (this.isArtificial != isArtificial) {
            this.isArtificial = isArtificial;
            this.shellDirty = true;
        }
    }

    @Override
    public Either<ShellState, PlayerSyncEvents.SyncFailureReason> sync(ShellState state) {
        PlayerSyncEvents.SyncFailureReason finalFailureReason;
        ShellStateContainer targetShellContainer;
        ShellStateContainer currentShellContainer;
        class_3222 player = (class_3222)this;
        class_2338 currentPos = this.method_24515();
        class_3218 currentWorld = player.method_14220();
        if (!this.canBeApplied(state) || state.getProgress() < 1.0f) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_SHELL);
        }
        boolean isDead = this.method_29504();
        ShellStateContainer shellStateContainer = currentShellContainer = isDead ? null : ShellStateContainer.find((class_1937)currentWorld, currentPos);
        if (!(isDead || currentShellContainer != null && currentShellContainer.getShellState() == null)) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_CURRENT_LOCATION);
        }
        PlayerSyncEvents.ShellSelectionFailureReason selectionFailureReason = ((PlayerSyncEvents.AllowShellSelection)PlayerSyncEvents.ALLOW_SHELL_SELECTION.invoker()).allowShellSelection((class_1657)player, currentShellContainer);
        if (selectionFailureReason != null) {
            return Either.right(selectionFailureReason::toText);
        }
        class_2960 targetWorldId = state.getWorld();
        class_3218 targetWorld = WorldUtil.findWorld(this.field_13995.method_3738(), targetWorldId).orElse(null);
        if (targetWorld == null) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_TARGET_LOCATION);
        }
        class_2338 targetPos = state.getPos();
        class_2791 targetChunk = targetWorld.method_22350(targetPos);
        ShellStateContainer shellStateContainer2 = targetShellContainer = targetChunk == null ? null : ShellStateContainer.find((class_1937)targetWorld, state);
        if (targetShellContainer == null) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_TARGET_LOCATION);
        }
        state = targetShellContainer.getShellState();
        PlayerSyncEvents.SyncFailureReason syncFailureReason = finalFailureReason = this.canBeApplied(state) ? ((PlayerSyncEvents.AllowSyncing)PlayerSyncEvents.ALLOW_SYNCING.invoker()).allowSync(this, state) : PlayerSyncEvents.SyncFailureReason.INVALID_SHELL;
        if (finalFailureReason != null) {
            return Either.right((Object)finalFailureReason);
        }
        ((PlayerSyncEvents.StartSyncing)PlayerSyncEvents.START_SYNCING.invoker()).onStartSyncing(this, state);
        ShellState storedState = null;
        if (currentShellContainer != null) {
            storedState = ShellState.of(player, currentPos, currentShellContainer.getColor());
            currentShellContainer.setShellState(storedState);
            if (currentShellContainer.isRemotelyAccessible()) {
                this.add(storedState);
            }
        }
        targetShellContainer.setShellState(null);
        this.remove(state);
        this.apply(state);
        ((PlayerSyncEvents.StopSyncing)PlayerSyncEvents.STOP_SYNCING.invoker()).onStopSyncing((class_1657)player, currentPos, storedState);
        return Either.left((Object)storedState);
    }

    @Override
    public void apply(ShellState state) {
        Objects.requireNonNull(state);
        class_3222 serverPlayer = (class_3222)this;
        MinecraftServer server = Objects.requireNonNull(this.field_6002.method_8503());
        class_3218 targetWorld = WorldUtil.findWorld(server.method_3738(), state.getWorld()).orElse(null);
        if (targetWorld == null) {
            return;
        }
        this.method_5848();
        this.method_7262();
        this.method_5646();
        this.method_32317(0);
        this.method_33572(false);
        this.method_6012();
        new PlayerIsAlivePacket((class_1657)serverPlayer).sendToAll(server);
        this.teleport(targetWorld, state.getPos());
        this.isArtificial = state.isArtificial();
        class_1661 inventory = this.method_31548();
        int selectedSlot = inventory.field_7545;
        state.getInventory().copyTo((class_1263)inventory);
        inventory.field_7545 = selectedSlot;
        ShellStateComponent playerComponent = ShellStateComponent.of(serverPlayer);
        playerComponent.clone(state.getComponent());
        serverPlayer.method_7336(class_1934.method_8384((int)state.getGameMode()));
        this.method_6033(state.getHealth());
        this.field_7520 = state.getExperienceLevel();
        this.field_7510 = state.getExperienceProgress();
        this.field_7495 = state.getTotalExperience();
        this.method_7344().method_7580(state.getFoodLevel());
        this.method_7344().method_7581(state.getSaturationLevel());
        this.method_7344().method_35218(state.getExhaustion());
        this.undead = false;
        this.field_6272 = false;
        this.field_6213 = 0;
        this.field_6017 = 0.0f;
        this.field_13978 = -1;
        this.field_13997 = -1.0f;
        this.field_13979 = -1;
        this.shellDirty = true;
    }

    @Override
    public Stream<ShellState> getAvailableShellStates() {
        return this.shellsById.values().stream();
    }

    @Override
    public void setAvailableShellStates(Stream<ShellState> states) {
        this.shellsById = states.collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
        this.shellDirty = true;
    }

    @Override
    public ShellState getShellStateByUuid(UUID uuid) {
        return uuid == null ? null : (ShellState)this.shellsById.get(uuid);
    }

    @Override
    public void add(ShellState state) {
        if (!this.canBeApplied(state)) {
            return;
        }
        this.shellsById.put(state.getUuid(), state);
        this.shellStateChanges.put(state.getUuid(), (class_3545<ShellStateUpdateType, ShellState>)new class_3545((Object)ShellStateUpdateType.ADD, (Object)state));
    }

    @Override
    public void remove(ShellState state) {
        if (state == null) {
            return;
        }
        if (this.shellsById.remove(state.getUuid()) != null) {
            this.shellStateChanges.put(state.getUuid(), (class_3545<ShellStateUpdateType, ShellState>)new class_3545((Object)ShellStateUpdateType.REMOVE, (Object)state));
        }
    }

    @Override
    public void update(ShellState state) {
        if (state == null) {
            return;
        }
        boolean updated = this.canBeApplied(state) ? this.shellsById.put(state.getUuid(), state) != null : this.shellsById.computeIfPresent(state.getUuid(), (a, b) -> state) != null;
        this.shellStateChanges.put(state.getUuid(), (class_3545<ShellStateUpdateType, ShellState>)new class_3545((Object)(updated ? ShellStateUpdateType.UPDATE : ShellStateUpdateType.ADD), (Object)state));
    }

    @Inject(method={"playerTick"}, at={@At(value="HEAD")})
    private void playerTick(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (this.shellDirty) {
            this.shellDirty = false;
            this.shellStateChanges.clear();
            new ShellUpdatePacket(WorldUtil.getId(this.field_6002), this.isArtificial, this.shellsById.values()).send(player);
        }
        for (class_3545<ShellStateUpdateType, ShellState> upd : this.shellStateChanges.values()) {
            new ShellStateUpdatePacket((ShellStateUpdateType)((Object)upd.method_15442()), (ShellState)upd.method_15441()).send(player);
        }
        this.shellStateChanges.clear();
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDeath(class_1282 source, CallbackInfo ci) {
        if (!this.isArtificial) {
            return;
        }
        ShellState respawnShell = this.shellsById.values().stream().filter(x -> this.canBeApplied((ShellState)x) && x.getProgress() >= 1.0f).findAny().orElse(null);
        if (respawnShell == null) {
            return;
        }
        if (this.field_6002.method_8450().method_8355(class_1928.field_19398)) {
            this.sendDeathMessageInChat();
        }
        if (this.field_6002.method_8450().method_8355(class_1928.field_25401)) {
            this.method_29779();
        }
        if (!this.method_7325()) {
            this.method_16080(source);
        }
        this.undead = true;
        ci.cancel();
    }

    protected void method_6108() {
        this.field_6213 = class_3532.method_15340((int)(++this.field_6213), (int)0, (int)20);
        if (this.isArtificial && this.shellsById.values().stream().anyMatch(x -> this.canBeApplied((ShellState)x) && x.getProgress() >= 1.0f)) {
            return;
        }
        if (this.undead) {
            this.method_6078(class_1282.field_5846);
            this.undead = false;
        }
        if (this.field_6213 == 20) {
            this.field_6002.method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Unique
    private void sendDeathMessageInChat() {
        class_2561 text = this.method_6066().method_5548();
        class_270 team = this.method_5781();
        if (team != null && team.method_1200() != class_270.class_272.field_1442) {
            if (team.method_1200() == class_270.class_272.field_1444) {
                this.field_13995.method_3760().method_14564((class_1657)this, text);
            } else if (team.method_1200() == class_270.class_272.field_1446) {
                this.field_13995.method_3760().method_14565((class_1657)this, text);
            }
        } else {
            this.field_13995.method_3760().method_14616(text, class_2556.field_11735, class_156.field_25140);
        }
    }

    @Shadow
    protected abstract void method_29779();

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        class_2499 shellList = new class_2499();
        this.shellsById.values().stream().map(x -> x.writeNbt(new class_2487())).forEach(arg_0 -> shellList.add(arg_0));
        nbt.method_10556("IsArtificial", this.isArtificial);
        nbt.method_10566("Shells", (class_2520)shellList);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.isArtificial = nbt.method_10577("IsArtificial");
        this.shellsById = nbt.method_10554("Shells", 10).stream().map(x -> ShellState.fromNbt((class_2487)x)).collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
        Collection<class_3545<ShellStateUpdateType, ShellState>> updates = ((ShellStateManager)this.field_13995).popPendingUpdates(this.field_6021);
        for (class_3545<ShellStateUpdateType, ShellState> update : updates) {
            ShellState state = (ShellState)update.method_15441();
            switch ((ShellStateUpdateType)((Object)update.method_15442())) {
                case ADD: 
                case UPDATE: {
                    if (!this.field_6021.equals(state.getOwnerUuid())) break;
                    this.shellsById.put(state.getUuid(), state);
                    break;
                }
                case REMOVE: {
                    this.shellsById.remove(state.getUuid());
                }
            }
        }
        this.shellStateChanges = new HashMap<UUID, class_3545<ShellStateUpdateType, ShellState>>();
        this.shellDirty = true;
    }

    @Inject(method={"copyFrom"}, at={@At(value="HEAD")})
    private void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        Shell shell = (Shell)oldPlayer;
        this.isArtificial = alive && shell.isArtificial();
        this.shellsById = shell.getAvailableShellStates().collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
        this.shellStateChanges = new HashMap<UUID, class_3545<ShellStateUpdateType, ShellState>>();
        this.shellDirty = true;
    }

    @Inject(method={"setWorld"}, at={@At(value="HEAD")})
    private void setWorld(class_3218 world, CallbackInfo ci) {
        if (world != this.field_6002) {
            this.shellDirty = true;
        }
    }

    @Unique
    private void teleport(class_3218 targetWorld, class_2338 pos) {
        class_2791 chunk = targetWorld.method_22350(pos);
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        float yaw = BlockPosUtil.getHorizontalFacing(pos, (class_1922)chunk).map(d -> Float.valueOf(d.method_10153().method_10144())).orElse(Float.valueOf(0.0f)).floatValue();
        float pitch = 0.0f;
        if (this.field_6002 == targetWorld) {
            this.method_5710(yaw, pitch);
            this.method_24203(x, y, z);
            return;
        }
        class_3218 serverWorld = (class_3218)this.field_6002;
        class_3222 serverPlayer = (class_3222)this;
        class_5217 worldProperties = targetWorld.method_8401();
        serverPlayer.field_13987.method_14364((class_2596)new class_2724(targetWorld.method_8597(), targetWorld.method_27983(), class_4543.method_27984((long)targetWorld.method_8412()), serverPlayer.field_13974.method_14257(), serverPlayer.field_13974.method_30119(), targetWorld.method_27982(), targetWorld.method_28125(), true));
        serverPlayer.field_13987.method_14364((class_2596)new class_2632(worldProperties.method_207(), worldProperties.method_197()));
        class_3324 playerManager = Objects.requireNonNull(this.field_6002.method_8503()).method_3760();
        playerManager.method_14576(serverPlayer);
        serverWorld.method_18770(serverPlayer, class_1297.class_5529.field_27002);
        this.method_31482();
        serverPlayer.method_32747(targetWorld);
        targetWorld.method_18211(serverPlayer);
        this.method_5710(yaw, pitch);
        this.method_24203(x, y, z);
        serverPlayer.field_13987.method_14364((class_2596)new class_2696(serverPlayer.method_31549()));
        playerManager.method_14606(serverPlayer, targetWorld);
        playerManager.method_14594(serverPlayer);
    }
}

