/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.api.networking.ShellDestroyedPacket;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.entity.BooleanAnimator;
import dev.kir.sync.block.entity.DoubleBlockEntity;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.item.SimpleInventory;
import dev.kir.sync.util.ItemUtil;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4732;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShellContainerBlockEntity
extends class_2586
implements ShellStateContainer,
DoubleBlockEntity,
TickableBlockEntity,
class_1263 {
    protected final BooleanAnimator doorAnimator;
    protected ShellState shell;
    protected class_1767 color;
    protected int progressComparatorOutput;
    protected int inventoryComparatorOutput;
    private AbstractShellContainerBlockEntity bottomPart;
    private ShellState syncedShell;
    private class_2338 syncedShellPos;
    private class_1767 syncedShellColor;
    private float syncedShellProgress;
    private class_1767 syncedColor;
    private boolean inventoryDirty;
    private boolean visibleInventoryDirty;

    public AbstractShellContainerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.doorAnimator = new BooleanAnimator(AbstractShellContainerBlock.isOpen(state));
    }

    @Override
    public void setShellState(ShellState shell) {
        this.shell = shell;
    }

    @Override
    public ShellState getShellState() {
        return this.shell;
    }

    @Override
    @Nullable
    public class_1767 getColor() {
        return this.color;
    }

    public int getProgressComparatorOutput() {
        return this.getBottomPart().map(x -> x.progressComparatorOutput).orElse(0);
    }

    public int getInventoryComparatorOutput() {
        return this.getBottomPart().map(x -> x.inventoryComparatorOutput).orElse(0);
    }

    protected ShellStateManager getShellStateManager() {
        return (ShellStateManager)Objects.requireNonNull(this.field_11863).method_8503();
    }

    protected Optional<AbstractShellContainerBlockEntity> getBottomPart() {
        if (this.bottomPart == null && this.field_11863 != null) {
            AbstractShellContainerBlockEntity x;
            class_2586 class_25862;
            this.bottomPart = AbstractShellContainerBlock.isBottom(this.method_11010()) ? this : ((class_25862 = this.field_11863.method_8321(this.field_11867.method_10093(class_2350.field_11033))) instanceof AbstractShellContainerBlockEntity ? (x = (AbstractShellContainerBlockEntity)class_25862) : null);
        }
        return Optional.ofNullable(this.bottomPart);
    }

    @Override
    public void onServerTick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.shell != null && this.shell.getColor() != this.color) {
            this.shell.setColor(this.color);
        }
        if (this.requiresSync()) {
            this.updateShell(this.shell != this.syncedShell, !this.visibleInventoryDirty);
            this.updateComparatorOutput(world, pos, state);
            this.syncedShellPos = this.shell == null ? null : this.shell.getPos();
            this.syncedShellColor = this.shell == null ? null : this.shell.getColor();
            this.syncedShellProgress = this.shell == null ? -1.0f : this.shell.getProgress();
            this.syncedShell = this.shell;
            this.syncedColor = this.color;
            this.inventoryDirty = false;
            this.visibleInventoryDirty = false;
            this.sync();
            world.method_8524(pos);
        }
        if (this.inventoryDirty) {
            this.updateComparatorOutput(world, pos, state);
            this.inventoryDirty = false;
            world.method_8524(pos);
        }
    }

    private boolean requiresSync() {
        return this.visibleInventoryDirty || this.syncedShell != this.shell || this.syncedColor != this.color || this.shell != null && (!this.shell.getPos().equals((Object)this.syncedShellPos) || !Objects.equals(this.shell.getColor(), this.syncedShellColor) || this.shell.getProgress() != this.syncedShellProgress);
    }

    private void updateShell(boolean isNew, boolean partialUpdate) {
        ShellStateManager shellManager = this.getShellStateManager();
        if (isNew) {
            shellManager.remove(this.syncedShell);
            shellManager.add(this.shell);
        } else if (partialUpdate) {
            shellManager.update(this.shell);
        } else {
            shellManager.add(this.shell);
        }
    }

    private void updateComparatorOutput(class_1937 world, class_2338 pos, class_2680 state) {
        int currentProgressOutput = this.shell == null ? 0 : class_3532.method_15340((int)((int)(this.shell.getProgress() * 15.0f)), (int)1, (int)15);
        int currentInventoryOutput = this.shell == null ? 0 : class_1703.method_7618((class_1263)this.shell.getInventory());
        class_2338 topPartPos = pos.method_10093(AbstractShellContainerBlock.getDirectionTowardsAnotherPart(state));
        class_2680 topPartState = world.method_8320(topPartPos);
        if (this.progressComparatorOutput != currentProgressOutput) {
            this.progressComparatorOutput = currentProgressOutput;
            if (state.method_11654(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.PROGRESS) {
                world.method_8455(pos, state.method_26204());
            }
            if (topPartState.method_28498(AbstractShellContainerBlock.OUTPUT) && topPartState.method_11654(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.PROGRESS) {
                world.method_8455(topPartPos, topPartState.method_26204());
            }
        }
        if (this.inventoryComparatorOutput != currentInventoryOutput) {
            this.inventoryComparatorOutput = currentInventoryOutput;
            if (state.method_11654(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.INVENTORY) {
                world.method_8455(pos, state.method_26204());
            }
            if (topPartState.method_28498(AbstractShellContainerBlock.OUTPUT) && topPartState.method_11654(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.INVENTORY) {
                world.method_8455(topPartPos, topPartState.method_26204());
            }
        }
    }

    @Override
    public void onClientTick(class_1937 world, class_2338 pos, class_2680 state) {
        this.doorAnimator.setValue(AbstractShellContainerBlock.isOpen(state));
        this.doorAnimator.step();
    }

    public void onBreak(class_1937 world, class_2338 pos) {
        if (this.shell != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.getShellStateManager().remove(this.shell);
            this.destroyShell(serverWorld, pos);
        }
    }

    protected void destroyShell(class_3218 world, class_2338 pos) {
        if (this.shell != null) {
            this.shell.drop(world, pos);
            new ShellDestroyedPacket(pos).send(PlayerLookup.around((class_3218)world, (class_2382)pos, (double)32.0));
            this.shell = null;
        }
    }

    public abstract class_1269 onUse(class_1937 var1, class_2338 var2, class_1657 var3, class_1268 var4);

    @Environment(value=EnvType.CLIENT)
    public float getDoorOpenProgress(float tickDelta) {
        return this.getBottomPart().map(x -> Float.valueOf(x.doorAnimator.getProgress(tickDelta))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public class_4732.class_4733 getBlockType(class_2680 state) {
        return AbstractShellContainerBlock.getShellContainerHalf(state);
    }

    protected void sync() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.shell != null) {
            nbt.method_10566("shell", (class_2520)this.shell.writeNbt(new class_2487()));
        }
        nbt.method_10569("color", this.color == null ? -1 : this.color.method_7789());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.shell = nbt.method_10545("shell") ? ShellState.fromNbt(nbt.method_10562("shell")) : null;
        int colorId = nbt.method_10573("color", 3) ? nbt.method_10550("color") : -1;
        this.color = colorId == -1 ? null : class_1767.method_7791((int)colorId);
    }

    private static int reorderSlotIndex(int slot, SimpleInventory inventory) {
        int mainSize = inventory.main.size();
        int armorSize = inventory.armor.size();
        int offHandSize = inventory.offHand.size();
        return slot >= 0 && slot < armorSize ? slot + mainSize : (slot >= armorSize && slot < armorSize + offHandSize ? slot + mainSize : slot - armorSize - offHandSize);
    }

    private static boolean isVisibleSlot(int slot, SimpleInventory inventory) {
        int armorSize = inventory.armor.size();
        int offHandSize = inventory.offHand.size();
        return slot >= 0 && slot <= armorSize + offHandSize;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        boolean isOffHandSlot;
        boolean isArmorSlot;
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return false;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        int armorSize = inventory.armor.size();
        boolean bl = isArmorSlot = slot >= 0 && slot < armorSize;
        if (isArmorSlot) {
            class_1304 equipmentSlot = ItemUtil.getPreferredEquipmentSlot(stack);
            return ItemUtil.isArmor(stack) && equipmentSlot.method_5925() == class_1304.class_1305.field_6178 && slot == equipmentSlot.method_5927();
        }
        boolean bl2 = isOffHandSlot = slot >= armorSize && slot < armorSize + inventory.offHand.size();
        if (isOffHandSlot) {
            return ItemUtil.getPreferredEquipmentSlot(stack) == class_1304.field_6171 || inventory.main.stream().noneMatch(x -> x.method_7960() || x.method_7947() + stack.method_7947() <= x.method_7914() && class_1799.method_31577((class_1799)x, (class_1799)stack));
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return this.getBottomPart().filter(x -> x.shell != null).map(x -> x.shell.getInventory().method_5438(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, x.shell.getInventory()))).orElse(class_1799.field_8037);
    }

    public void method_5447(int slot, class_1799 stack) {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null || bottom.shell.getProgress() < 1.0f) {
            return;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        inventory.method_5447(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, inventory), stack);
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty |= AbstractShellContainerBlockEntity.isVisibleSlot(slot, inventory);
    }

    public class_1799 method_5434(int slot, int amount) {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return class_1799.field_8037;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        class_1799 removed = inventory.method_5434(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, inventory), amount);
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty = bottom.visibleInventoryDirty | (!removed.method_7960() && AbstractShellContainerBlockEntity.isVisibleSlot(slot, inventory));
        return removed;
    }

    public class_1799 method_5441(int slot) {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return class_1799.field_8037;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        class_1799 removed = inventory.method_5441(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, inventory));
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty = bottom.visibleInventoryDirty | (!removed.method_7960() && AbstractShellContainerBlockEntity.isVisibleSlot(slot, inventory));
        return removed;
    }

    public void method_5448() {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return;
        }
        bottom.shell.getInventory().method_5448();
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty = true;
    }

    public int method_5439() {
        return this.getBottomPart().map(x -> x.shell == null || x.shell.getProgress() < 1.0f ? 0 : x.shell.getInventory().method_5439()).orElse(0);
    }

    public boolean method_5442() {
        return this.getBottomPart().map(x -> x.shell == null || x.shell.getInventory().method_5442()).orElse(true);
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }
}

