/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import dev.kir.sync.util.nbt.OfflinePlayerNbtManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3324;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin
implements ShellStateManager {
    @Shadow
    private class_3324 field_4550;
    @Unique
    private final ConcurrentMap<UUID, ConcurrentMap<UUID, class_3545<ShellStateUpdateType, ShellState>>> pendingShellStates = new ConcurrentHashMap<UUID, ConcurrentMap<UUID, class_3545<ShellStateUpdateType, ShellState>>>();

    @Override
    public void setAvailableShellStates(UUID owner, Stream<ShellState> states) {
        Shell shell = this.getShellById(owner);
        if (shell != null) {
            shell.setAvailableShellStates(states);
        }
    }

    @Override
    public Stream<ShellState> getAvailableShellStates(UUID owner) {
        Shell shell = this.getShellById(owner);
        return shell == null ? Stream.of(new ShellState[0]) : shell.getAvailableShellStates();
    }

    @Override
    public ShellState getShellStateByUuid(UUID owner, UUID uuid) {
        Shell shell = this.getShellById(owner);
        return shell == null ? null : shell.getShellStateByUuid(uuid);
    }

    @Override
    public void add(ShellState state) {
        Shell shell = this.getShellByItsState(state);
        if (shell != null) {
            shell.add(state);
        }
    }

    @Override
    public void remove(ShellState state) {
        Shell shell = this.getShellByItsState(state);
        if (shell == null) {
            this.putPendingUpdate(state, ShellStateUpdateType.REMOVE);
        } else {
            shell.remove(state);
        }
    }

    @Override
    public void update(ShellState state) {
        Shell shell = this.getShellByItsState(state);
        if (shell == null) {
            this.putPendingUpdate(state, ShellStateUpdateType.UPDATE);
        } else {
            shell.update(state);
        }
    }

    @Override
    public Collection<class_3545<ShellStateUpdateType, ShellState>> peekPendingUpdates(UUID owner) {
        Map shells = (Map)this.pendingShellStates.get(owner);
        if (shells == null) {
            return List.of();
        }
        return shells.values();
    }

    @Override
    public void clearPendingUpdates(UUID owner) {
        this.pendingShellStates.remove(owner);
    }

    @Inject(method={"shutdown"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;disconnectAllPlayers()V")})
    private void onShutdown(CallbackInfo ci) {
        for (Map.Entry entry : this.pendingShellStates.entrySet()) {
            UUID userId = (UUID)entry.getKey();
            Collection updates = ((ConcurrentMap)entry.getValue()).values();
            if (updates.size() == 0) continue;
            OfflinePlayerNbtManager.editPlayerNbt((MinecraftServer)this, userId, nbt -> {
                Map<UUID, ShellState> shells = nbt.method_10554("Shells", 10).stream().map(x -> ShellState.fromNbt((class_2487)x)).collect(Collectors.toMap(ShellState::getUuid, x -> x));
                for (class_3545 update : updates) {
                    ShellState state = (ShellState)update.method_15441();
                    switch ((ShellStateUpdateType)((Object)((Object)update.method_15442()))) {
                        case ADD: 
                        case UPDATE: {
                            if (!userId.equals(state.getOwnerUuid())) break;
                            shells.put(state.getUuid(), state);
                            break;
                        }
                        case REMOVE: {
                            shells.remove(state.getUuid());
                        }
                    }
                }
                class_2499 shellList = new class_2499();
                shells.values().stream().map(x -> x.writeNbt(new class_2487())).forEach(arg_0 -> shellList.add(arg_0));
                nbt.method_10566("Shells", (class_2520)shellList);
            });
        }
        this.pendingShellStates.clear();
    }

    @Unique
    private void putPendingUpdate(ShellState state, ShellStateUpdateType updateType) {
        if (state == null || updateType == ShellStateUpdateType.NONE) {
            return;
        }
        ConcurrentHashMap<UUID, class_3545> updates = (ConcurrentHashMap<UUID, class_3545>)this.pendingShellStates.get(state.getOwnerUuid());
        if (updates == null) {
            updates = new ConcurrentHashMap<UUID, class_3545>();
            this.pendingShellStates.put(state.getOwnerUuid(), updates);
        }
        updates.put(state.getUuid(), new class_3545((Object)updateType, (Object)state));
    }

    @Unique
    private Shell getShellById(UUID id) {
        return this.isValidShellOwnerUuid(id) ? (Shell)this.field_4550.method_14602(id) : null;
    }

    @Unique
    private Shell getShellByItsState(ShellState state) {
        return this.isValidShellState(state) ? (Shell)this.field_4550.method_14602(state.getOwnerUuid()) : null;
    }
}

