/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block;

import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.block.entity.TreadmillBlockEntity;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class TreadmillBlock
extends class_2383
implements class_2343 {
    public static final class_2754<Part> PART = class_2754.method_11850((String)"treadmill_part", Part.class);
    private static final class_265 NORTH_SHAPE_BACK;
    private static final class_265 NORTH_SHAPE_FRONT;
    private static final class_265 SOUTH_SHAPE_BACK;
    private static final class_265 SOUTH_SHAPE_FRONT;
    private static final class_265 EAST_SHAPE_BACK;
    private static final class_265 EAST_SHAPE_FRONT;
    private static final class_265 WEST_SHAPE_BACK;
    private static final class_265 WEST_SHAPE_FRONT;

    public TreadmillBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)Part.BACK)));
    }

    public static boolean isBack(class_2680 state) {
        Part part = (Part)((Object)state.method_11654(PART));
        return part == Part.BACK;
    }

    public static class_4732.class_4733 getTreadmillPart(class_2680 state) {
        Part part = (Part)((Object)state.method_11654(PART));
        return part == Part.BACK ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TreadmillBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        TreadmillBlockEntity back;
        TreadmillBlockEntity firstTreadmill;
        class_2586 second;
        Part part;
        block5: {
            block4: {
                part = (Part)((Object)state.method_11654(PART));
                class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
                class_2586 first = world.method_8321(pos);
                second = world.method_8321(pos.method_10093(TreadmillBlock.getDirectionTowardsOtherPart(part, facing)));
                if (!(first instanceof TreadmillBlockEntity)) break block4;
                firstTreadmill = (TreadmillBlockEntity)first;
                if (second instanceof TreadmillBlockEntity) break block5;
            }
            return;
        }
        TreadmillBlockEntity secondTreadmill = (TreadmillBlockEntity)second;
        TreadmillBlockEntity front = part == Part.BACK ? secondTreadmill : firstTreadmill;
        TreadmillBlockEntity treadmillBlockEntity = back = part == Part.BACK ? firstTreadmill : secondTreadmill;
        if (back.isOverheated()) {
            double x = (double)front.method_11016().method_10263() + random.nextDouble();
            double y = (double)front.method_11016().method_10264() + 0.4;
            double z = (double)front.method_11016().method_10260() + random.nextDouble();
            world.method_8406((class_2394)class_2398.field_11237, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, PART});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == TreadmillBlock.getDirectionTowardsOtherPart((Part)((Object)state.method_11654(PART)), (class_2350)state.method_11654((class_2769)field_11177))) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART) ? state : class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        class_2338 blockPos = ctx.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        return ctx.method_8045().method_8320(blockPos2).method_26166(ctx) ? (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction) : null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2338 blockPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177));
            world.method_8652(blockPos, (class_2680)state.method_11657(PART, (Comparable)((Object)Part.FRONT)), 3);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        Part part;
        if (!world.field_9236 && player.method_7337() && (part = (Part)((Object)state.method_11654(PART))) == Part.FRONT && (blockState = world.method_8320(blockPos = pos.method_10093(TreadmillBlock.getDirectionTowardsOtherPart(part, (class_2350)state.method_11654((class_2769)field_11177))))).method_26204() == this && blockState.method_11654(PART) == Part.BACK) {
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        super.method_9576(world, pos, state, player);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return true;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        boolean isBack = TreadmillBlock.isBack(state);
        return switch (direction) {
            case class_2350.field_11043 -> {
                if (isBack) {
                    yield NORTH_SHAPE_BACK;
                }
                yield NORTH_SHAPE_FRONT;
            }
            case class_2350.field_11035 -> {
                if (isBack) {
                    yield SOUTH_SHAPE_BACK;
                }
                yield SOUTH_SHAPE_FRONT;
            }
            case class_2350.field_11034 -> {
                if (isBack) {
                    yield EAST_SHAPE_BACK;
                }
                yield EAST_SHAPE_FRONT;
            }
            case class_2350.field_11039 -> {
                if (isBack) {
                    yield WEST_SHAPE_BACK;
                }
                yield WEST_SHAPE_FRONT;
            }
            default -> NORTH_SHAPE_FRONT;
        };
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_2586 class_25862;
        if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity treadmillBlockEntity = (TreadmillBlockEntity)class_25862;
            treadmillBlockEntity.onSteppedOn(pos, state, entity);
        }
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (type != SyncBlockEntities.TREADMILL || !TreadmillBlock.isBack(state)) {
            return null;
        }
        return world.field_9236 ? TickableBlockEntity::clientTicker : TickableBlockEntity::serverTicker;
    }

    public static class_2350 getDirectionTowardsOtherPart(Part part, class_2350 direction) {
        return part == Part.BACK ? direction : direction.method_10153();
    }

    static {
        class_265 TRACK_NORTH_SOUTH = class_2248.method_9541((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)4.0, (double)16.0);
        class_265 TRACK_EAST_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)4.0, (double)14.5);
        class_265 LEFT_SIDE_GUARD_NORTH_BACK = class_2248.method_9541((double)1.5, (double)0.0, (double)0.0, (double)1.6, (double)8.3, (double)7.4);
        class_265 RIGHT_SIDE_GUARD_NORTH_BACK = class_2248.method_9541((double)14.4, (double)0.0, (double)0.0, (double)14.5, (double)8.3, (double)7.4);
        class_265 LEFT_SIDE_GUARD_NORTH_FRONT = class_2248.method_9541((double)1.5, (double)0.0, (double)7.5, (double)1.6, (double)8.7, (double)16.0);
        class_265 RIGHT_SIDE_GUARD_NORTH_FRONT = class_2248.method_9541((double)14.4, (double)0.0, (double)7.5, (double)14.5, (double)8.7, (double)16.0);
        class_265 DASHBOARD_NORTH_FRONT = class_2248.method_9541((double)1.5, (double)0.0, (double)2.0, (double)14.5, (double)8.5, (double)3.0);
        class_265 LEFT_SIDE_GUARD_SOUTH_BACK = class_2248.method_9541((double)1.5, (double)0.0, (double)8.6, (double)1.6, (double)8.3, (double)16.0);
        class_265 RIGHT_SIDE_GUARD_SOUTH_BACK = class_2248.method_9541((double)14.4, (double)0.0, (double)8.6, (double)14.5, (double)8.3, (double)16.0);
        class_265 LEFT_SIDE_GUARD_SOUTH_FRONT = class_2248.method_9541((double)1.5, (double)0.0, (double)0.0, (double)1.6, (double)8.7, (double)8.5);
        class_265 RIGHT_SIDE_GUARD_SOUTH_FRONT = class_2248.method_9541((double)14.4, (double)0.0, (double)0.0, (double)14.5, (double)8.7, (double)8.5);
        class_265 DASHBOARD_SOUTH_FRONT = class_2248.method_9541((double)1.5, (double)0.0, (double)13.0, (double)14.5, (double)8.5, (double)14.0);
        class_265 LEFT_SIDE_GUARD_EAST_BACK = class_2248.method_9541((double)8.6, (double)0.0, (double)1.5, (double)16.0, (double)8.3, (double)1.6);
        class_265 RIGHT_SIDE_GUARD_EAST_BACK = class_2248.method_9541((double)8.6, (double)0.0, (double)14.4, (double)16.0, (double)8.3, (double)14.5);
        class_265 LEFT_SIDE_GUARD_EAST_FRONT = class_2248.method_9541((double)0.0, (double)0.0, (double)1.5, (double)8.5, (double)8.7, (double)1.6);
        class_265 RIGHT_SIDE_GUARD_EAST_FRONT = class_2248.method_9541((double)0.0, (double)0.0, (double)14.4, (double)8.5, (double)8.7, (double)14.5);
        class_265 DASHBOARD_EAST_FRONT = class_2248.method_9541((double)13.0, (double)0.0, (double)1.5, (double)14.0, (double)8.5, (double)14.5);
        class_265 LEFT_SIDE_GUARD_WEST_BACK = class_2248.method_9541((double)0.0, (double)0.0, (double)1.5, (double)7.4, (double)8.3, (double)1.6);
        class_265 RIGHT_SIDE_GUARD_WEST_BACK = class_2248.method_9541((double)0.0, (double)0.0, (double)14.4, (double)7.4, (double)8.3, (double)14.5);
        class_265 LEFT_SIDE_GUARD_WEST_FRONT = class_2248.method_9541((double)7.5, (double)0.0, (double)1.5, (double)16.0, (double)8.7, (double)1.6);
        class_265 RIGHT_SIDE_GUARD_WEST_FRONT = class_2248.method_9541((double)7.5, (double)0.0, (double)14.4, (double)16.0, (double)8.7, (double)14.5);
        class_265 DASHBOARD_WEST_FRONT = class_2248.method_9541((double)2.0, (double)0.0, (double)1.5, (double)3.0, (double)8.5, (double)14.5);
        NORTH_SHAPE_BACK = class_259.method_17786((class_265)TRACK_NORTH_SOUTH, (class_265[])new class_265[]{LEFT_SIDE_GUARD_NORTH_BACK, RIGHT_SIDE_GUARD_NORTH_BACK}).method_1097();
        NORTH_SHAPE_FRONT = class_259.method_17786((class_265)TRACK_NORTH_SOUTH, (class_265[])new class_265[]{LEFT_SIDE_GUARD_NORTH_FRONT, RIGHT_SIDE_GUARD_NORTH_FRONT, DASHBOARD_NORTH_FRONT}).method_1097();
        SOUTH_SHAPE_BACK = class_259.method_17786((class_265)TRACK_NORTH_SOUTH, (class_265[])new class_265[]{LEFT_SIDE_GUARD_SOUTH_BACK, RIGHT_SIDE_GUARD_SOUTH_BACK}).method_1097();
        SOUTH_SHAPE_FRONT = class_259.method_17786((class_265)TRACK_NORTH_SOUTH, (class_265[])new class_265[]{LEFT_SIDE_GUARD_SOUTH_FRONT, RIGHT_SIDE_GUARD_SOUTH_FRONT, DASHBOARD_SOUTH_FRONT}).method_1097();
        EAST_SHAPE_BACK = class_259.method_17786((class_265)TRACK_EAST_WEST, (class_265[])new class_265[]{LEFT_SIDE_GUARD_EAST_BACK, RIGHT_SIDE_GUARD_EAST_BACK}).method_1097();
        EAST_SHAPE_FRONT = class_259.method_17786((class_265)TRACK_EAST_WEST, (class_265[])new class_265[]{LEFT_SIDE_GUARD_EAST_FRONT, RIGHT_SIDE_GUARD_EAST_FRONT, DASHBOARD_EAST_FRONT}).method_1097();
        WEST_SHAPE_BACK = class_259.method_17786((class_265)TRACK_EAST_WEST, (class_265[])new class_265[]{LEFT_SIDE_GUARD_WEST_BACK, RIGHT_SIDE_GUARD_WEST_BACK}).method_1097();
        WEST_SHAPE_FRONT = class_259.method_17786((class_265)TRACK_EAST_WEST, (class_265[])new class_265[]{LEFT_SIDE_GUARD_WEST_FRONT, RIGHT_SIDE_GUARD_WEST_FRONT, DASHBOARD_WEST_FRONT}).method_1097();
    }

    public static enum Part implements class_3542
    {
        FRONT("front"),
        BACK("back");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

