/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.compat.mixin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class MixinCompat
implements IMixinConfigPlugin {
    private static final Map<String, String> PACKAGE_TO_ID = Map.of();

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String targetModId = MixinCompat.getTargetModId(mixinClassName);
        return FabricLoader.getInstance().isModLoaded(targetModId);
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static String getTargetModId(String mixinClassName) {
        String packageName = MixinCompat.getPackageName(mixinClassName);
        return PACKAGE_TO_ID.getOrDefault(packageName, packageName);
    }

    private static String getPackageName(String mixinClassName) {
        int mixinStartI = mixinClassName.lastIndexOf("mixin.");
        if (mixinStartI == -1) {
            return mixinClassName;
        }
        int endI = mixinClassName.indexOf(46, mixinStartI + 6);
        return mixinClassName.substring(mixinStartI + 6, endI);
    }
}

