/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.client;

import com.google.common.collect.Queues;
import dev.kir.sync.Sync;
import dev.kir.sync.util.WorldUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class PlayerUtil {
    private static final class_2960 ANY_WORLD = Sync.locate("any_world");
    private static final class_310 CLIENT = class_310.method_1551();
    private static final ConcurrentMap<class_2960, ConcurrentLinkedQueue<PlayerUpdate>> UPDATES = new ConcurrentHashMap<class_2960, ConcurrentLinkedQueue<PlayerUpdate>>();

    public static void recordPlayerUpdate(PlayerUpdate playerUpdate) {
        PlayerUtil.recordPlayerUpdate(null, playerUpdate);
    }

    public static void recordPlayerUpdate(class_2960 worldId, PlayerUpdate playerUpdate) {
        class_2960 class_29602 = worldId = worldId == null ? ANY_WORLD : worldId;
        if (PlayerUtil.CLIENT.field_1724 != null && PlayerUtil.existsInTargetWorld((class_1297)PlayerUtil.CLIENT.field_1724, worldId)) {
            playerUpdate.onLoad(PlayerUtil.CLIENT.field_1724, PlayerUtil.CLIENT.field_1724.field_17892, CLIENT);
        } else {
            UPDATES.computeIfAbsent(worldId, id -> Queues.newConcurrentLinkedQueue()).add(playerUpdate);
        }
    }

    private static boolean existsInTargetWorld(class_1297 entity, class_2960 worldId) {
        return worldId == ANY_WORLD || WorldUtil.isOf(worldId, entity.field_6002);
    }

    private static void executeUpdates(class_746 player, class_638 world, ConcurrentLinkedQueue<PlayerUpdate> queue) {
        if (queue == null) {
            return;
        }
        while (!queue.isEmpty()) {
            queue.poll().onLoad(player, world, CLIENT);
        }
    }

    static {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity == PlayerUtil.CLIENT.field_1724) {
                PlayerUtil.executeUpdates(PlayerUtil.CLIENT.field_1724, world, (ConcurrentLinkedQueue)UPDATES.get(WorldUtil.getId((class_1937)world)));
                PlayerUtil.executeUpdates(PlayerUtil.CLIENT.field_1724, world, (ConcurrentLinkedQueue)UPDATES.get(ANY_WORLD));
            }
        });
    }

    @FunctionalInterface
    public static interface PlayerUpdate {
        public void onLoad(class_746 var1, class_638 var2, class_310 var3);
    }
}

