/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.math;

import dev.kir.sync.util.math.Function;

public class QuarticFunction
extends Function {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double d0;
    private final double d1;
    private final double d2;

    public QuarticFunction(double a, double b, double c, double d, double e) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        double p0 = 2.0 * QuarticFunction.cube(c) - 9.0 * b * c * d + 27.0 * a * d * d + 27.0 * b * b * e - 72.0 * a * c * e;
        double p1 = c * c - 3.0 * b * d + 12.0 * a * e;
        double p2 = p0 + Math.sqrt(-4.0 * QuarticFunction.cube(p1) + p0 * p0);
        double p3 = p1 / (3.0 * a * Math.pow(p2 / 2.0, 0.3333333333333333)) + Math.pow(p2 / 2.0, 0.3333333333333333) / 3.0 / a;
        this.d0 = Math.sqrt(b * b / 4.0 / a / a - 2.0 * c / 3.0 / a + p3);
        this.d1 = b * b / 2.0 / a / a - 4.0 * c / 3.0 / a - p3;
        this.d2 = (-QuarticFunction.cube(b) / QuarticFunction.cube(a) + 4.0 * b * c / a / a - 8.0 * d / a) / 4.0 / this.d0;
    }

    @Override
    public int getDegree() {
        return 4;
    }

    @Override
    public double evaluate(double x) {
        return this.a * QuarticFunction.square(QuarticFunction.square(x)) + this.b * QuarticFunction.cube(x) + this.c * QuarticFunction.square(x) + this.d * x + this.e;
    }

    @Override
    protected double computeRoot(int i) {
        int sign0 = i < 2 ? -1 : 1;
        int sign1 = i % 2 == 0 ? -1 : 1;
        return -this.b / (4.0 * this.a) + (double)sign0 * this.d0 / 2.0 + (double)sign1 * Math.sqrt(this.d1 + (double)sign0 * this.d2) / 2.0;
    }
}

