/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.ShellStorageBlock;
import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.block.entity.BooleanAnimator;
import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.client.gui.ShellSelectorGUI;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.util.BlockPosUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import team.reborn.energy.api.EnergyStorage;

public class ShellStorageBlockEntity
extends AbstractShellContainerBlockEntity
implements EnergyStorage {
    private EntityState entityState = EntityState.NONE;
    private int ticksWithoutPower;
    private long storedEnergy;
    private final BooleanAnimator connectorAnimator = new BooleanAnimator(false);

    public ShellStorageBlockEntity(class_2338 pos, class_2680 state) {
        super(SyncBlockEntities.SHELL_STORAGE, pos, state);
    }

    public class_1767 getIndicatorColor() {
        if (this.field_11863 != null && ShellStorageBlock.isPowered(this.method_11010())) {
            return this.color == null ? class_1767.field_7961 : this.color;
        }
        return class_1767.field_7964;
    }

    @Environment(value=EnvType.CLIENT)
    public float getConnectorProgress(float tickDelta) {
        return this.getBottomPart().map(x -> Float.valueOf(((ShellStorageBlockEntity)x).connectorAnimator.getProgress(tickDelta))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void onServerTick(class_1937 world, class_2338 pos, class_2680 state) {
        super.onServerTick(world, pos, state);
        SyncConfig config = Sync.getConfig();
        boolean isReceivingRedstonePower = config.shellStorageAcceptsRedstone() && ShellStorageBlock.isEnabled(state);
        boolean hasEnergy = this.storedEnergy > 0L;
        boolean isPowered = isReceivingRedstonePower || hasEnergy;
        boolean shouldBeOpen = isPowered && this.getBottomPart().map(x -> x.shell == null).orElse(true) != false;
        ShellStorageBlock.setPowered(state, world, pos, isPowered);
        ShellStorageBlock.setOpen(state, world, pos, shouldBeOpen);
        if (this.shell != null && !isPowered) {
            ++this.ticksWithoutPower;
            if (this.ticksWithoutPower >= config.shellStorageMaxUnpoweredLifespan()) {
                this.destroyShell((class_3218)world, pos);
            }
        } else {
            this.ticksWithoutPower = 0;
        }
        if (!isReceivingRedstonePower && hasEnergy) {
            this.storedEnergy = class_3532.method_24156((long)(this.storedEnergy - config.shellStorageConsumption()), (long)0L, (long)config.shellStorageCapacity());
        }
    }

    @Override
    public void onClientTick(class_1937 world, class_2338 pos, class_2680 state) {
        super.onClientTick(world, pos, state);
        this.connectorAnimator.setValue(this.shell != null);
        this.connectorAnimator.step();
        if (this.entityState == EntityState.LEAVING || this.entityState == EntityState.CHILLING) {
            this.entityState = BlockPosUtil.hasPlayerInside(pos, (class_1924)world) ? this.entityState : EntityState.NONE;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onEntityCollisionClient(class_1297 entity, class_2680 state) {
        class_310 client = class_310.method_1551();
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (this.entityState == EntityState.NONE) {
            boolean isInside = BlockPosUtil.isEntityInside(entity, this.field_11867);
            PlayerSyncEvents.ShellSelectionFailureReason failureReason = !isInside && client.field_1724 == entity ? ((PlayerSyncEvents.AllowShellSelection)PlayerSyncEvents.ALLOW_SHELL_SELECTION.invoker()).allowShellSelection(player, this) : null;
            EntityState entityState = this.entityState = isInside || failureReason != null ? EntityState.CHILLING : EntityState.ENTERING;
            if (failureReason != null) {
                player.method_7353(failureReason.toText(), true);
            }
        } else if (this.entityState != EntityState.CHILLING && client.field_1755 == null) {
            BlockPosUtil.moveEntity(entity, this.field_11867, (class_2350)state.method_11654((class_2769)ShellStorageBlock.FACING), this.entityState == EntityState.ENTERING);
        }
        if (this.entityState == EntityState.ENTERING && client.field_1724 == entity && client.field_1755 == null && BlockPosUtil.isEntityInside(entity, this.field_11867)) {
            client.method_1507((class_437)new ShellSelectorGUI(() -> {
                this.entityState = EntityState.LEAVING;
            }, () -> {
                this.entityState = EntityState.CHILLING;
            }));
        }
    }

    @Override
    public class_1269 onUse(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (stack.method_7947() > 0 && item instanceof class_1769) {
            class_1769 dye = (class_1769)item;
            stack.method_7934(1);
            this.color = dye.method_7802();
        }
        return class_1269.field_5812;
    }

    public boolean supportsInsertion() {
        return true;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long insert(long amount, TransactionContext context) {
        ShellStorageBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null) {
            return 0L;
        }
        long capacity = bottom.getCapacity();
        long maxEnergy = class_3532.method_24156((long)(capacity - bottom.storedEnergy), (long)0L, (long)capacity);
        long inserted = class_3532.method_24156((long)amount, (long)0L, (long)maxEnergy);
        context.addCloseCallback((ctx, result) -> {
            if (result.wasCommitted()) {
                bottom.storedEnergy += inserted;
            }
        });
        return inserted;
    }

    public long extract(long amount, TransactionContext context) {
        return 0L;
    }

    public long getAmount() {
        return 0L;
    }

    public long getCapacity() {
        return Sync.getConfig().shellStorageCapacity();
    }

    static {
        ShellStateContainer.LOOKUP.registerForBlockEntity((x, s) -> x.method_11002() && AbstractShellContainerBlock.isBottom(x.method_11010()) && (s == null || s.equals(x.getShellState())) ? x : null, SyncBlockEntities.SHELL_STORAGE);
        EnergyStorage.SIDED.registerForBlockEntities((x, __) -> (EnergyStorage)x, new class_2591[]{SyncBlockEntities.SHELL_STORAGE});
    }

    private static enum EntityState {
        NONE,
        ENTERING,
        CHILLING,
        LEAVING;

    }
}

