/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import dev.kir.sync.client.gui.widget.AbstractButtonWidget;
import dev.kir.sync.util.client.render.ColorUtil;
import dev.kir.sync.util.client.render.RenderSystemUtil;
import dev.kir.sync.util.math.QuarticFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class ArrowButtonWidget
extends AbstractButtonWidget {
    private static final class_2561 DEFAULT_DESCRIPTION = null;
    private static final int DEFAULT_COLOR = ColorUtil.fromDyeColor(class_1767.field_7952);
    private static final float DEFAULT_STEP = 0.09817477f;
    public final ArrowType type;
    private final float step;
    private final float[] color;
    private final class_2561 description;
    private final float x0;
    private final float y0;
    private final float x1;
    private final float y1;
    private final float borderRadius;
    private final float stickWidth;
    private final float stickHeight;
    private final float angle;

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, DEFAULT_COLOR, DEFAULT_DESCRIPTION, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, class_2561 description, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, DEFAULT_COLOR, description, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, int color, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, color, DEFAULT_DESCRIPTION, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, int color, class_2561 description, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, color, description, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, float step, int color, class_2561 description, Runnable onClick) {
        super(x, y, type.isVertical() ? width : height, type.isVertical() ? height : width, onClick);
        this.type = type;
        this.step = step;
        this.color = ColorUtil.toRGBA(color);
        this.description = description;
        float shiftY = (float)new QuarticFunction(1.0, -2.0f * height, height * height + width * width / 4.0f, 0.0, -width * width / 4.0f * thickness * thickness).getRoot(1);
        this.angle = (float)Math.acos(shiftY / thickness);
        this.x0 = x;
        this.y0 = y + height - shiftY;
        this.x1 = x + width / 2.0f;
        this.y1 = y;
        this.borderRadius = thickness * 0.5f;
        this.stickHeight = thickness;
        this.stickWidth = class_3532.method_15355((float)(class_3532.method_27285((float)(width / 2.0f)) + class_3532.method_27285((float)(height - shiftY))));
    }

    @Override
    protected void renderContent(class_4587 matrices, int mouseX, int mouseY, float delta) {
        matrices.method_22903();
        this.type.transform(matrices, this.x, this.y, this.width, this.height);
        RenderSystemUtil.drawRectangle(matrices, this.x0, this.y0, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, -this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
        RenderSystemUtil.drawRectangle(matrices, this.x1, this.y1, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
        matrices.method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.visible && this.type.isValidKey(keyCode)) {
            this.onMouseClick(0.0, 0.0, 0);
            return true;
        }
        return false;
    }

    @Override
    protected class_2561 getWidgetDescription() {
        return this.description;
    }

    public static enum ArrowType {
        UP(0, 265, 266, 87),
        RIGHT(1, 262, 68),
        DOWN(2, 264, 267, 83),
        LEFT(3, 263, 65);

        private final int i;
        private final int[] keyCodes;

        private ArrowType(int i, int ... keyCodes) {
            this.i = i;
            this.keyCodes = keyCodes;
        }

        public boolean isValidKey(int keyCode) {
            for (int code : this.keyCodes) {
                if (code != keyCode) continue;
                return true;
            }
            return false;
        }

        public boolean isUp() {
            return this == UP;
        }

        public boolean isRight() {
            return this == RIGHT;
        }

        public boolean isLeft() {
            return this == LEFT;
        }

        public boolean isDown() {
            return this == DOWN;
        }

        public boolean isVertical() {
            return this == UP || this == DOWN;
        }

        public boolean isHorizontal() {
            return this == LEFT || this == RIGHT;
        }

        public void transform(class_4587 matrices, float x, float y, float width, float height) {
            if (this.isHorizontal()) {
                float tmp = width;
                width = height;
                height = tmp;
            }
            matrices.method_22904((double)x, (double)y, 0.0);
            matrices.method_22907(class_1160.field_20707.method_23626(1.5707964f * (float)this.i));
            matrices.method_22904((double)(-x - (this.i == 2 || this.i == 3 ? width : 0.0f)), (double)(-y - (this.i == 1 || this.i == 2 ? height : 0.0f)), 0.0);
        }
    }
}

