/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kir.sync.client.texture.TextureGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public final class GeneratedTextureManager {
    private static final Map<TextureGenerator, class_2960[]> GENERATED_TEXTURES = new HashMap<TextureGenerator, class_2960[]>();
    private static final class_2960[] EMPTY_TEXTURES = new class_2960[0];

    public static class_2960[] getTextures(TextureGenerator generator) {
        class_2960[] textures = GENERATED_TEXTURES.get(generator);
        if (textures == null) {
            if (RenderSystem.isOnRenderThreadOrInit()) {
                textures = GeneratedTextureManager.genTextures(generator, GENERATED_TEXTURES.size());
                GENERATED_TEXTURES.put(generator, textures);
            } else {
                RenderSystem.recordRenderCall(() -> GENERATED_TEXTURES.put(generator, GeneratedTextureManager.genTextures(generator, GENERATED_TEXTURES.size())));
                textures = EMPTY_TEXTURES;
            }
        }
        return textures;
    }

    private static class_2960[] genTextures(TextureGenerator generator, int generatorId) {
        RenderSystem.assertOnRenderThreadOrInit();
        int textureCounter = -1;
        String format = generator.getClass().getSimpleName().toLowerCase() + "_" + generatorId + "_";
        class_1060 textureManager = class_310.method_1551().method_1531();
        ArrayList<class_2960> textures = new ArrayList<class_2960>();
        for (class_1044 texture : generator.generateTextures()::iterator) {
            class_2960 id = new class_2960("__dynamic", format + ++textureCounter);
            textureManager.method_4616(id, texture);
            textures.add(id);
        }
        return textures.toArray(new class_2960[0]);
    }
}

