/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.compat.origins;

import dev.kir.sync.api.shell.ShellStateComponent;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

class OriginsShellStateComponent
extends ShellStateComponent {
    private final class_3222 player;
    private boolean activated;
    private class_2487 originComponentNbt;
    private class_2487 powerHolderComponentNbt;

    public OriginsShellStateComponent() {
        this(null, false);
    }

    public OriginsShellStateComponent(class_3222 player) {
        this(player, true);
    }

    private OriginsShellStateComponent(class_3222 player, boolean activated) {
        this.player = player;
        this.activated = activated;
    }

    @Override
    public String getId() {
        return "origins";
    }

    public boolean isActivated() {
        return this.activated;
    }

    public class_2487 getOriginComponentNbt() {
        class_2487 nbt = this.originComponentNbt;
        if (this.player != null) {
            nbt = new class_2487();
            ((OriginComponent)ModComponents.ORIGIN.get((Object)this.player)).writeToNbt(nbt);
        }
        return nbt == null ? new class_2487() : nbt;
    }

    public class_2487 getPowerHolderComponentNbt() {
        class_2487 nbt = this.powerHolderComponentNbt;
        if (this.player != null) {
            nbt = new class_2487();
            ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player)).writeToNbt(nbt);
        }
        return nbt == null ? new class_2487() : nbt;
    }

    @Override
    public void clone(ShellStateComponent component) {
        OriginsShellStateComponent other = component.as(OriginsShellStateComponent.class);
        if (other == null) {
            return;
        }
        this.originComponentNbt = other.getOriginComponentNbt();
        this.powerHolderComponentNbt = other.getPowerHolderComponentNbt();
        this.activated = other.isActivated();
        if (this.player == null) {
            return;
        }
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)this.player);
        if (this.activated) {
            originComponent.readFromNbt(this.originComponentNbt);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
            powerHolderComponent.readFromNbt(this.powerHolderComponentNbt);
            originComponent.sync();
        } else {
            for (OriginLayer layer : OriginLayers.getLayers()) {
                if (!layer.isEnabled()) continue;
                originComponent.setOrigin(layer, Origin.EMPTY);
            }
            originComponent.checkAutoChoosingLayers((class_1657)this.player, false);
            originComponent.sync();
            class_2540 data = new class_2540(Unpooled.buffer());
            data.writeBoolean(false);
            ServerPlayNetworking.send((class_3222)this.player, (class_2960)ModPackets.OPEN_ORIGIN_SCREEN, (class_2540)data);
            this.activated = true;
        }
    }

    @Override
    protected void readComponentNbt(class_2487 nbt) {
        this.originComponentNbt = nbt.method_10573("origins", 10) ? nbt.method_10562("origins") : new class_2487();
        this.powerHolderComponentNbt = nbt.method_10573("powers", 10) ? nbt.method_10562("powers") : new class_2487();
        this.activated = nbt.method_10577("activated");
    }

    @Override
    protected class_2487 writeComponentNbt(class_2487 nbt) {
        nbt.method_10566("origins", (class_2520)this.getOriginComponentNbt());
        nbt.method_10566("powers", (class_2520)this.getPowerHolderComponentNbt());
        nbt.method_10556("activated", this.isActivated());
        return nbt;
    }
}

