/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.compat.trinkets;

import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketsApi;
import dev.kir.sync.api.shell.ShellStateComponent;
import dev.kir.sync.item.SimpleInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3829;

class TrinketShellStateComponent
extends ShellStateComponent {
    final Map<String, Map<String, class_1263>> inventory;

    public TrinketShellStateComponent(class_1309 entity) {
        this.inventory = TrinketsApi.getTrinketComponent((class_1309)entity).map(x -> x.getInventory()).orElseGet(HashMap::new);
    }

    public TrinketShellStateComponent(class_1299<?> entityType) {
        this.inventory = new HashMap<String, Map<String, class_1263>>();
        for (Map.Entry groupEntry : TrinketsApi.getEntitySlots(entityType).entrySet()) {
            Map group = this.inventory.computeIfAbsent((String)groupEntry.getKey(), x -> new HashMap());
            for (Map.Entry slotEntry : ((SlotGroup)groupEntry.getValue()).getSlots().entrySet()) {
                group.put((String)slotEntry.getKey(), new SimpleInventory());
            }
        }
    }

    @Override
    public String getId() {
        return "trinkets";
    }

    @Override
    public Collection<class_1799> getItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1263 inv : this.inventory.values().stream().flatMap(x -> x.values().stream())::iterator) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public void clear() {
        this.inventory.values().forEach(x -> x.values().forEach(class_3829::method_5448));
    }

    @Override
    public void clone(ShellStateComponent component) {
        this.clear();
        TrinketShellStateComponent trinketComponent = component.as(TrinketShellStateComponent.class);
        if (trinketComponent == null) {
            return;
        }
        for (Map.Entry<String, Map<String, class_1263>> sourceGroupEntry : trinketComponent.inventory.entrySet()) {
            Map<String, class_1263> targetGroup = this.inventory.get(sourceGroupEntry.getKey());
            if (targetGroup == null) continue;
            for (Map.Entry<String, class_1263> sourceSlotEntry : sourceGroupEntry.getValue().entrySet()) {
                class_1263 targetSlot = targetGroup.get(sourceSlotEntry.getKey());
                if (targetSlot == null) continue;
                class_1263 sourceSlot = sourceSlotEntry.getValue();
                int size = Math.min(sourceSlot.method_5439(), targetSlot.method_5439());
                for (int i = 0; i < size; ++i) {
                    targetSlot.method_5447(i, sourceSlot.method_5438(i));
                }
            }
        }
    }

    @Override
    public class_2487 writeComponentNbt(class_2487 nbt) {
        for (Map.Entry<String, Map<String, class_1263>> group : this.inventory.entrySet()) {
            class_2487 groupTag = new class_2487();
            for (Map.Entry<String, class_1263> slot : group.getValue().entrySet()) {
                class_2487 slotTag = new class_2487();
                class_2499 list = new class_2499();
                class_1263 inv = slot.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    list.add((Object)inv.method_5438(i).method_7953(new class_2487()));
                }
                slotTag.method_10566("Items", (class_2520)list);
                groupTag.method_10566(slot.getKey(), (class_2520)slotTag);
            }
            nbt.method_10566(group.getKey(), (class_2520)groupTag);
        }
        return nbt;
    }

    @Override
    public void readComponentNbt(class_2487 nbt) {
        for (String groupKey : nbt.method_10541()) {
            class_2487 groupTag = nbt.method_10562(groupKey);
            Map<String, class_1263> groupSlots = this.inventory.get(groupKey);
            if (groupTag == null || groupSlots == null) continue;
            for (String slotKey : groupTag.method_10541()) {
                class_2487 slotTag = groupTag.method_10562(slotKey);
                class_2499 list = slotTag.method_10554("Items", 10);
                class_1263 inv = groupSlots.get(slotKey);
                if (inv == null) continue;
                int size = Math.min(list.size(), inv.method_5439());
                for (int i = 0; i < size; ++i) {
                    class_1799 stack = class_1799.method_7915((class_2487)list.method_10602(i));
                    inv.method_5447(i, stack);
                }
            }
        }
    }
}

