/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.event;

import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class PlayerSyncEvents {
    public static final Event<AllowSyncing> ALLOW_SYNCING = EventFactory.createArrayBacked(AllowSyncing.class, callbacks -> (player, targetState) -> {
        for (AllowSyncing callback : callbacks) {
            SyncFailureReason reason = callback.allowSync(player, targetState);
            if (reason == null) continue;
            return reason;
        }
        return null;
    });
    public static final Event<AllowShellConstruction> ALLOW_SHELL_CONSTRUCTION = EventFactory.createArrayBacked(AllowShellConstruction.class, callbacks -> (player, targetContainer) -> {
        for (AllowShellConstruction callback : callbacks) {
            ShellConstructionFailureReason reason = callback.allowShellConstruction(player, targetContainer);
            if (reason == null) continue;
            return reason;
        }
        return null;
    });
    public static final Event<AllowShellSelection> ALLOW_SHELL_SELECTION = EventFactory.createArrayBacked(AllowShellSelection.class, callbacks -> (player, targetContainer) -> {
        for (AllowShellSelection callback : callbacks) {
            ShellSelectionFailureReason reason = callback.allowShellSelection(player, targetContainer);
            if (reason == null) continue;
            return reason;
        }
        return null;
    });
    public static final Event<StartSyncing> START_SYNCING = EventFactory.createArrayBacked(StartSyncing.class, callbacks -> (player, targetState) -> {
        for (StartSyncing callback : callbacks) {
            callback.onStartSyncing(player, targetState);
        }
    });
    public static final Event<StopSyncing> STOP_SYNCING = EventFactory.createArrayBacked(StopSyncing.class, callbacks -> (player, previousPos, storedState) -> {
        for (StopSyncing callback : callbacks) {
            callback.onStopSyncing(player, previousPos, storedState);
        }
    });

    private PlayerSyncEvents() {
    }

    @FunctionalInterface
    public static interface StopSyncing {
        public void onStopSyncing(class_1657 var1, class_2338 var2, @Nullable ShellState var3);
    }

    @FunctionalInterface
    public static interface StartSyncing {
        public void onStartSyncing(class_1657 var1, ShellState var2);
    }

    @FunctionalInterface
    public static interface AllowShellSelection {
        @Nullable
        public ShellSelectionFailureReason allowShellSelection(class_1657 var1, ShellStateContainer var2);
    }

    @FunctionalInterface
    public static interface ShellSelectionFailureReason {
        public static final ShellSelectionFailureReason OTHER_PROBLEM = () -> null;

        @Nullable
        public class_2561 toText();

        public static ShellSelectionFailureReason create(@Nullable class_2561 description) {
            return description == null ? OTHER_PROBLEM : () -> description;
        }
    }

    @FunctionalInterface
    public static interface AllowShellConstruction {
        @Nullable
        public ShellConstructionFailureReason allowShellConstruction(class_1657 var1, ShellStateContainer var2);
    }

    @FunctionalInterface
    public static interface ShellConstructionFailureReason {
        public static final ShellConstructionFailureReason OTHER_PROBLEM = () -> null;
        public static final ShellConstructionFailureReason OCCUPIED = ShellConstructionFailureReason.create((class_2561)class_2561.method_43471((String)"event.sync.construction.fail.occupied"));
        public static final ShellConstructionFailureReason NOT_ENOUGH_HEALTH = ShellConstructionFailureReason.create((class_2561)class_2561.method_43471((String)"event.sync.construction.fail.health"));

        @Nullable
        public class_2561 toText();

        public static ShellConstructionFailureReason create(@Nullable class_2561 description) {
            return description == null ? OTHER_PROBLEM : () -> description;
        }
    }

    @FunctionalInterface
    public static interface AllowSyncing {
        @Nullable
        public SyncFailureReason allowSync(class_1657 var1, ShellState var2);
    }

    @FunctionalInterface
    public static interface SyncFailureReason {
        public static final SyncFailureReason OTHER_PROBLEM = () -> null;
        public static final SyncFailureReason INVALID_SHELL = SyncFailureReason.create((class_2561)class_2561.method_43471((String)"event.sync.request.fail.invalid.shell"));
        public static final SyncFailureReason INVALID_CURRENT_LOCATION = SyncFailureReason.create((class_2561)class_2561.method_43471((String)"event.sync.request.fail.invalid.location.current"));
        public static final SyncFailureReason INVALID_TARGET_LOCATION = SyncFailureReason.create((class_2561)class_2561.method_43471((String)"event.sync.request.fail.invalid.location.target"));

        @Nullable
        public class_2561 toText();

        public static SyncFailureReason create(@Nullable class_2561 description) {
            return description == null ? OTHER_PROBLEM : () -> description;
        }
    }
}

