/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.event.EntityFitnessEvents;
import dev.kir.sync.block.TreadmillBlock;
import dev.kir.sync.block.entity.DoubleBlockEntity;
import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.easteregg.technoblade.TechnobladeManager;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4732;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class TreadmillBlockEntity
extends class_2586
implements DoubleBlockEntity,
TickableBlockEntity,
EnergyStorage {
    private static final int MAX_RUNNING_TIME = 18000;
    private static final double MAX_SQUARED_DISTANCE = 0.5;
    private static final Map<class_1299<? extends class_1297>, Long> ENERGY_MAP = Sync.getConfig().energyMap().stream().collect(Collectors.toUnmodifiableMap(SyncConfig.EnergyMapEntry::getEntityType, SyncConfig.EnergyMapEntry::outputEnergyQuantity, (a, b) -> a));
    private UUID runnerUUID;
    private Integer runnerId;
    private class_1297 runner;
    private int runningTime;
    private long storedEnergy;
    private long producibleEnergyQuantity;
    private TreadmillBlockEntity cachedBackPart;

    public TreadmillBlockEntity(class_2338 pos, class_2680 state) {
        super(SyncBlockEntities.TREADMILL, pos, state);
    }

    private void setRunner(class_1297 entity) {
        if (this.runner == entity) {
            return;
        }
        if (this.runner != null) {
            ((EntityFitnessEvents.StopRunning)EntityFitnessEvents.STOP_RUNNING.invoker()).onStopRunning(this.runner, this);
        }
        if (entity == null) {
            this.runningTime = 0;
            this.producibleEnergyQuantity = 0L;
        }
        this.runner = entity;
        if (this.runner != null) {
            ((EntityFitnessEvents.StartRunning)EntityFitnessEvents.START_RUNNING.invoker()).onStartRunning(this.runner, this);
        }
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            TechnobladeManager.refreshTechnobladeStatus(entity, this.field_11867);
        } else {
            this.method_5431();
            this.sync();
        }
    }

    @Override
    public void onClientTick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.runnerId != null) {
            this.setRunner(world.method_8469(this.runnerId.intValue()));
            this.runnerId = null;
        }
        if (this.runner == null) {
            return;
        }
        class_1297 class_12972 = this.runner;
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            livingEntity.field_6225 = 1.5f + 2.0f * (float)this.runningTime / 18000.0f;
        }
        this.runningTime = Math.min(++this.runningTime, 18000);
    }

    @Override
    public void onServerTick(class_1937 world, class_2338 pos, class_2680 state) {
        class_1297 class_12972;
        if (this.runnerUUID != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.setRunner(serverWorld.method_14190(this.runnerUUID));
            this.runnerUUID = null;
        }
        if (this.runner == null) {
            return;
        }
        class_2350 face = (class_2350)state.method_11654((class_2769)TreadmillBlock.field_11177);
        class_243 anchor = TreadmillBlockEntity.computeTreadmillPivot(pos, face);
        if (!TreadmillBlockEntity.isValidEntity(this.runner) || !TreadmillBlockEntity.isEntityNear(this.runner, anchor)) {
            this.setRunner(null);
            return;
        }
        if (!this.runner.method_31747()) {
            float yaw = face.method_10144();
            this.runner.method_5641(anchor.field_1352, anchor.field_1351, anchor.field_1350, yaw, 0.0f);
            this.runner.method_5847(yaw);
            this.runner.method_5636(yaw);
            this.runner.method_36456(yaw);
            this.runner.field_5982 = yaw;
        }
        if ((class_12972 = this.runner) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            livingEntity.method_16826(0);
        }
        this.storedEnergy = this.producibleEnergyQuantity * (long)(1.0 + 0.5 * (double)this.runningTime / 18000.0);
        this.transferEnergy(world, pos);
        if (this.runningTime < 18000) {
            ++this.runningTime;
            if (this.runningTime % 1000 == 0) {
                this.method_5431();
                this.sync();
            }
        }
    }

    public void onSteppedOn(class_2338 pos, class_2680 state, class_1297 entity) {
        Long energy;
        if (this.runner != null || !TreadmillBlockEntity.isEntityNear(entity, TreadmillBlockEntity.computeTreadmillPivot(pos, (class_2350)state.method_11654((class_2769)TreadmillBlock.field_11177)))) {
            return;
        }
        Long l = energy = TreadmillBlockEntity.isValidEntity(entity) ? TreadmillBlockEntity.getOutputEnergyQuantityForEntity(entity, this) : null;
        if (energy != null) {
            this.setRunner(entity);
            this.producibleEnergyQuantity = energy;
        }
    }

    public boolean isOverheated() {
        return this.runner != null && this.runningTime >= 18000;
    }

    public long getAmount() {
        TreadmillBlockEntity back = this.getBackPart();
        return back == null ? 0L : back.storedEnergy;
    }

    public long getCapacity() {
        TreadmillBlockEntity back = this.getBackPart();
        if (back == null || back.runner == null) {
            return 0L;
        }
        return back.producibleEnergyQuantity * (long)(1.0 + 0.5 * (double)back.runningTime / 18000.0);
    }

    public boolean supportsInsertion() {
        return false;
    }

    public boolean supportsExtraction() {
        return true;
    }

    public long insert(long maxAmount, TransactionContext context) {
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext context) {
        TreadmillBlockEntity back = this.getBackPart();
        if (back == null) {
            return 0L;
        }
        long extracted = Math.min(back.storedEnergy, maxAmount);
        context.addCloseCallback((ctx, result) -> {
            if (result.wasCommitted()) {
                back.storedEnergy -= extracted;
            }
        });
        return extracted;
    }

    private void transferEnergy(class_1937 world, class_2338 pos) {
        TreadmillBlockEntity back = this.getBackPart();
        if (back == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            for (class_2350 direction : class_2350.values()) {
                EnergyStorage target = (EnergyStorage)EnergyStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
                if (target == null || !target.supportsInsertion()) continue;
                EnergyStorageUtil.move((EnergyStorage)back, (EnergyStorage)target, (long)Long.MAX_VALUE, null);
                if (back.storedEnergy > 0L) continue;
                return;
            }
            pos = pos.method_10093((class_2350)this.method_11010().method_11654((class_2769)TreadmillBlock.field_11177));
        }
    }

    @Override
    public class_4732.class_4733 getBlockType(class_2680 state) {
        return TreadmillBlock.getTreadmillPart(state);
    }

    private TreadmillBlockEntity getBackPart() {
        if (this.cachedBackPart != null || this.field_11863 == null) {
            return this.cachedBackPart;
        }
        if (TreadmillBlock.isBack(this.method_11010())) {
            this.cachedBackPart = this;
        } else {
            class_2338 backPartPos = this.field_11867.method_10093(((class_2350)this.method_11010().method_11654((class_2769)TreadmillBlock.field_11177)).method_10153());
            this.cachedBackPart = this.field_11863.method_35230(backPartPos, SyncBlockEntities.TREADMILL).orElse(null);
        }
        return this.cachedBackPart;
    }

    protected void sync() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.runnerUUID = nbt.method_25928("runner") ? nbt.method_25926("runner") : null;
        this.runnerId = nbt.method_10573("runnerId", 3) ? nbt.method_10550("runnerId") : -1;
        this.producibleEnergyQuantity = nbt.method_10537("energy");
        this.runningTime = nbt.method_10550("time");
    }

    protected void method_11007(class_2487 nbt) {
        Integer runnerId;
        UUID runnerUuid;
        super.method_11007(nbt);
        Object object = this.runnerUUID == null ? (this.runner == null ? null : this.runner.method_5667()) : (runnerUuid = this.runnerUUID);
        if (runnerUuid != null) {
            nbt.method_25927("runner", runnerUuid);
        }
        Integer n = runnerId = this.runner == null ? null : Integer.valueOf(this.runner.method_5628());
        if (runnerId != null) {
            nbt.method_10569("runnerId", runnerId.intValue());
        }
        nbt.method_10544("energy", this.producibleEnergyQuantity);
        nbt.method_10569("time", this.runningTime);
    }

    private static Long getOutputEnergyQuantityForEntity(class_1297 entity, EnergyStorage energyStorage) {
        return ((EntityFitnessEvents.ModifyOutputEnergyQuantity)EntityFitnessEvents.MODIFY_OUTPUT_ENERGY_QUANTITY.invoker()).modifyOutputEnergyQuantity(entity, energyStorage, ENERGY_MAP.get(entity.method_5864()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidEntity(class_1297 entity) {
        if (entity == null) return false;
        if (!entity.method_5805()) {
            return false;
        }
        if (entity.method_7325()) return false;
        if (entity.method_5715()) return false;
        if (entity.method_5681()) return false;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (livingEntity.field_6235 > 0) return false;
            if (livingEntity.method_6109()) return false;
        }
        if (entity instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            if (mobEntity.method_5934()) return false;
        }
        if (!(entity instanceof class_1321)) return true;
        class_1321 tameableEntity = (class_1321)entity;
        if (tameableEntity.method_24345()) return false;
        return true;
    }

    private static boolean isEntityNear(class_1297 entity, class_243 pos) {
        return entity.method_5707(pos) < 0.5;
    }

    private static class_243 computeTreadmillPivot(class_2338 pos, class_2350 face) {
        double x = switch (face) {
            case class_2350.field_11039 -> pos.method_10263();
            case class_2350.field_11034 -> pos.method_10263() + 1;
            default -> (double)pos.method_10263() + 0.5;
        };
        double y = (double)pos.method_10264() + 0.175;
        double z = switch (face) {
            case class_2350.field_11035 -> pos.method_10260() + 1;
            case class_2350.field_11043 -> pos.method_10260();
            default -> (double)pos.method_10260() + 0.5;
        };
        return new class_243(x, y, z);
    }

    static {
        EnergyStorage.SIDED.registerForBlockEntities((x, __) -> (EnergyStorage)x, new class_2591[]{SyncBlockEntities.TREADMILL});
    }
}

