/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui;

import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.client.gl.MSAAFramebuffer;
import dev.kir.sync.client.gui.TooltipProvider;
import dev.kir.sync.client.gui.controller.HudController;
import dev.kir.sync.client.gui.widget.AbstractWidget;
import dev.kir.sync.client.gui.widget.ArrowButtonWidget;
import dev.kir.sync.client.gui.widget.CrossButtonWidget;
import dev.kir.sync.client.gui.widget.PageDisplayWidget;
import dev.kir.sync.client.gui.widget.ShellSelectorButtonWidget;
import dev.kir.sync.util.IdentifierUtil;
import dev.kir.sync.util.client.render.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ShellSelectorGUI
extends class_437 {
    private static final int MAX_SLOTS = 8;
    private static final double MENU_RADIUS = (double)0.3f;
    private static final int BACKGROUND_COLOR = ColorUtil.fromDyeColor(class_1767.field_7963, 0.3f);
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.sync.default.cross_button.title");
    private static final Collection<class_2561> ARROW_TITLES = List.of(class_2561.method_43471((String)"gui.sync.shell_selector.up.title"), class_2561.method_43471((String)"gui.sync.shell_selector.right.title"), class_2561.method_43471((String)"gui.sync.shell_selector.down.title"), class_2561.method_43471((String)"gui.sync.shell_selector.left.title"));
    private final Runnable onCloseCallback;
    private final Runnable onRemovedCallback;
    private boolean wasClosed;
    private List<ShellSelectorButtonWidget> shellButtons;
    private List<ArrowButtonWidget> arrowButtons;
    private CrossButtonWidget crossButton;
    private PageDisplayWidget<class_2960, ShellState> pageDisplay;

    public ShellSelectorGUI(Runnable onCloseCallback, Runnable onRemovedCallback) {
        super(TITLE);
        this.onCloseCallback = onCloseCallback;
        this.onRemovedCallback = onRemovedCallback;
    }

    public void method_25426() {
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        Stream<ShellState> data = ((Shell)player).getAvailableShellStates();
        class_2960 selectedWorld = player.field_6002.method_27983().method_29177();
        this.wasClosed = false;
        this.arrowButtons = ShellSelectorGUI.createArrowButtons(this.field_22789, this.field_22790, ARROW_TITLES, List.of(this::previousSection, this::nextPage, this::nextSection, this::previousPage));
        this.crossButton = ShellSelectorGUI.createCrossButton(this.field_22789, this.field_22790, this::method_25419);
        this.pageDisplay = ShellSelectorGUI.createPageDisplay(this.field_22789, this.field_22790, data, selectedWorld, 8, this::onPageChange);
        Stream.concat(this.arrowButtons.stream(), Stream.of(this.crossButton, this.pageDisplay)).forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.method_37063((class_364)x$0);
        });
        HudController.hide();
    }

    private static List<ShellSelectorButtonWidget> createShellButtons(int screenWidth, int screenHeight, int count) {
        double HOLLOW_R = 0.18f;
        double BORDER_WIDTH = 0.0033;
        double SECTOR_SPACING = 0.01;
        double cX = (double)screenWidth / 2.0;
        double cY = (double)screenHeight / 2.0;
        double majorR = (double)screenHeight * (double)0.3f;
        double minorR = (double)screenHeight * (double)0.18f;
        double spacing = count > 1 ? 0.01 : 0.0;
        double sector = (double)((float)Math.PI * 2 / (float)count) - spacing;
        double borderWidth = (double)screenHeight * 0.0033;
        double pos = -sector / (double)(2 << count % 2);
        ArrayList<ShellSelectorButtonWidget> shellButtons = new ArrayList<ShellSelectorButtonWidget>();
        for (int i = 0; i < count; ++i) {
            ShellSelectorButtonWidget button = new ShellSelectorButtonWidget(cX, cY, majorR, minorR, borderWidth, pos, pos + sector);
            pos += sector + spacing;
            shellButtons.add(button);
        }
        return shellButtons;
    }

    private static PageDisplayWidget<class_2960, ShellState> createPageDisplay(int screenWidth, int screenHeight, Stream<ShellState> data, class_2960 defaultPage, int entriesPerPage, BiConsumer<PageDisplayWidget<class_2960, ShellState>, PageDisplayWidget.Page> onChange) {
        float FONT_HEIGHT = 0.033333335f;
        float cX = (float)screenWidth / 2.0f;
        float cY = (float)screenHeight / 2.0f;
        float f = (float)screenHeight * 0.033333335f;
        Objects.requireNonNull(class_310.method_1551().field_1772);
        float scale = f / 9.0f;
        return new PageDisplayWidget<class_2960, ShellState>(cX, cY, scale, data, ShellState::getWorld, IdentifierUtil::prettifyAsText, defaultPage, entriesPerPage, onChange);
    }

    private static List<ArrowButtonWidget> createArrowButtons(int screenWidth, int screenHeight, Iterable<class_2561> arrowTitles, Iterable<Runnable> arrowActions) {
        float ARROW_HEIGHT = 0.026666667f;
        float ARROW_WIDTH = 1.78125f;
        float ARROW_THICKNESS = 0.004166667f;
        float ARROW_SPACING = 0.071428575f;
        float cX = (float)screenWidth / 2.0f;
        float cY = (float)screenHeight / 2.0f;
        float r = (float)screenHeight * 0.3f * 1.0714285f;
        float arrowHeight = (float)screenHeight * 0.026666667f;
        float arrowWidth = arrowHeight * 1.78125f;
        float thickness = (float)screenHeight * 0.004166667f;
        Iterator<Runnable> actions = arrowActions.iterator();
        Iterator<class_2561> descriptions = arrowTitles.iterator();
        ArrayList<ArrowButtonWidget> arrowButtons = new ArrayList<ArrowButtonWidget>();
        for (ArrowButtonWidget.ArrowType arrowType : ArrowButtonWidget.ArrowType.values()) {
            float y;
            float x;
            if (arrowType.isVertical()) {
                x = (float)screenWidth / 2.0f - arrowWidth / 2.0f;
                y = cY + r * (float)(arrowType.isDown() ? 1 : -1) + (arrowType.isDown() ? 0.0f : -arrowHeight);
            } else {
                x = cX + r * (float)(arrowType.isRight() ? 1 : -1) + (arrowType.isRight() ? 0.0f : -arrowHeight);
                y = (float)screenHeight / 2.0f - arrowWidth / 2.0f;
            }
            arrowButtons.add(new ArrowButtonWidget(x, y, arrowWidth, arrowHeight, arrowType, thickness, descriptions.next(), actions.next()));
        }
        return arrowButtons;
    }

    private static CrossButtonWidget createCrossButton(int screenWidth, int screenHeight, Runnable onClose) {
        float CROSS_MARGIN = 0.06666667f;
        float CROSS_WIDTH = 0.026666667f;
        float CROSS_THICKNESS = 0.004166667f;
        float width = (float)screenHeight * 0.026666667f;
        float y = (float)screenHeight * 0.06666667f;
        float x = (float)screenWidth - y - width;
        float thickness = (float)screenHeight * 0.004166667f;
        return new CrossButtonWidget(x, y, width, width, thickness, onClose);
    }

    public void method_25433(class_4587 matrices, int vOffset) {
        if (Objects.requireNonNull(this.field_22787).field_1687 != null) {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, BACKGROUND_COLOR, BACKGROUND_COLOR);
        } else {
            super.method_25433(matrices, vOffset);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        MSAAFramebuffer.use(MSAAFramebuffer.MAX_SAMPLES, () -> super.method_25394(matrices, mouseX, mouseY, delta));
        this.renderTooltips(matrices, mouseX, mouseY);
    }

    protected void renderTooltips(class_4587 matrices, int mouseX, int mouseY) {
        for (class_364 child : this.method_25396()) {
            class_2561 tooltipText;
            class_6379 selectable;
            if (!(child instanceof class_6379) || (selectable = (class_6379)child).method_37018() == class_6379.class_6380.field_33784) continue;
            if (selectable instanceof TooltipProvider) {
                TooltipProvider tooltipProvider = (TooltipProvider)selectable;
                v0 = tooltipProvider.getTooltip();
            } else {
                v0 = tooltipText = null;
            }
            if (tooltipText != null) {
                this.method_25424(matrices, tooltipText, mouseX, mouseY);
            }
            return;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (class_364 child : this.method_25396()) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private void onPageChange(PageDisplayWidget<class_2960, ShellState> pageDisplay, PageDisplayWidget.Page page) {
        for (ArrowButtonWidget arrow : this.arrowButtons) {
            arrow.visible = arrow.type.isVertical() ? pageDisplay.hasMoreSections() : pageDisplay.hasMorePages();
        }
        if (this.shellButtons != null) {
            this.shellButtons.forEach(x$0 -> this.method_37066((class_364)x$0));
        }
        List content = page.content;
        this.shellButtons = ShellSelectorGUI.createShellButtons(this.field_22789, this.field_22790, Math.max(content.size(), 1));
        this.shellButtons.forEach(x$0 -> {
            ShellSelectorButtonWidget cfr_ignored_0 = (ShellSelectorButtonWidget)this.method_37063((class_364)x$0);
        });
        for (int i = 0; i < content.size(); ++i) {
            this.shellButtons.get((int)i).shell = (ShellState)content.get(i);
        }
    }

    private void nextSection() {
        this.pageDisplay.nextSection();
    }

    private void previousSection() {
        this.pageDisplay.previousSection();
    }

    private void nextPage() {
        this.pageDisplay.nextPage();
    }

    private void previousPage() {
        this.pageDisplay.previousPage();
    }

    public void method_25419() {
        HudController.restore();
        if (this.onCloseCallback != null) {
            this.onCloseCallback.run();
        }
        this.wasClosed = true;
        super.method_25419();
    }

    public void method_25432() {
        super.method_25432();
        if (!this.wasClosed && this.onRemovedCallback != null) {
            this.onRemovedCallback.run();
        }
    }
}

