/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import dev.kir.sync.client.gui.widget.AbstractButtonWidget;
import dev.kir.sync.util.client.render.ColorUtil;
import dev.kir.sync.util.client.render.RenderSystemUtil;
import dev.kir.sync.util.math.QuarticFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class CrossButtonWidget
extends AbstractButtonWidget {
    private static final class_2561 DEFAULT_DESCRIPTION = class_2561.method_43471((String)"gui.sync.default.cross_button.title");
    private static final int DEFAULT_COLOR = ColorUtil.fromDyeColor(class_1767.field_7952);
    private static final float DEFAULT_STEP = 0.09817477f;
    private final float step;
    private final float[] color;
    private final class_2561 description;
    private final float x0;
    private final float y0;
    private final float x1;
    private final float y1;
    private final float borderRadius;
    private final float stickWidth;
    private final float stickHeight;
    private final float angle;

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, DEFAULT_COLOR, DEFAULT_DESCRIPTION, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, int color, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, color, DEFAULT_DESCRIPTION, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, class_2561 description, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, DEFAULT_COLOR, description, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, int color, class_2561 description, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, color, description, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, float step, int color, class_2561 description, Runnable onClick) {
        super(x, y, width, height, onClick);
        this.step = step;
        this.color = ColorUtil.toRGBA(color);
        this.description = description;
        float shiftY = (float)new QuarticFunction(4.0, -4.0f * height, height * height + width * width - 4.0f * thickness * thickness, 2.0f * height * thickness * thickness, thickness * thickness * (thickness * thickness - width * width)).getRoot(1);
        float shiftX = (float)Math.sqrt(thickness * thickness - shiftY * shiftY);
        this.angle = (float)Math.acos(shiftY / thickness);
        this.x0 = x;
        this.y0 = y + height - shiftY;
        this.x1 = x + shiftX;
        this.y1 = y;
        this.borderRadius = thickness * 0.5f;
        this.stickHeight = thickness;
        this.stickWidth = class_3532.method_15355((float)(class_3532.method_27285((float)(width - shiftX)) + class_3532.method_27285((float)(height - shiftY))));
    }

    @Override
    protected void renderContent(class_4587 matrices, int mouseX, int mouseY, float delta) {
        RenderSystemUtil.drawRectangle(matrices, this.x0, this.y0, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, -this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
        RenderSystemUtil.drawRectangle(matrices, this.x1, this.y1, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    @Override
    protected class_2561 getWidgetDescription() {
        return this.description;
    }
}

